//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: dhendrickson
//
// Date: Feb 7, 2008
//---------------------

package org.cleversafe.protocol;

import static org.junit.Assert.assertTrue;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import java.util.Arrays;

import org.cleversafe.layer.protocol.GridProtocolHeaderCodec;
import org.cleversafe.layer.protocol.ProtocolMessage;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.layer.protocol.SequencedProtocolMessage;
import org.cleversafe.layer.protocol.exceptions.ProtocolSerializationException;
import org.cleversafe.serialization.GridProtocolMessageFactory;
import org.cleversafe.serialization.ProtocolMessageFactory;
import org.cleversafe.serialization.raw.RawGridProtocolMessageFactory;
import org.junit.Test;

public abstract class ProtocolVerificationTest
{
   private byte[] expectedRequest;
   private byte[] expectedResponse;
   
   private ProtocolMessageFactory messageFactory;
   
   public ProtocolVerificationTest()
   {
      this.messageFactory = new RawGridProtocolMessageFactory();
   }
   
   private byte[] getMessageBytes(ProtocolMessage message)
   {
      ByteArrayOutputStream byteStream =
         new ByteArrayOutputStream(GridProtocolHeaderCodec.LENGTH
               + this.messageFactory.getMaxSerializedSize(message));
      DataOutputStream outputStream = new DataOutputStream(byteStream);
      
      short protocolVersion = GridProtocolMessageFactory.getGridProtocolVersion();
      
      GridProtocolHeaderCodec header =
            new GridProtocolHeaderCodec(protocolVersion,
                  ((SequencedProtocolMessage) message).getSequenceNumber(),
                  message.getOperation().getOperationCode(), 0);
      
      try
      {
         header.serialize(outputStream);
         this.messageFactory.serialize(outputStream, message);
      }
      catch(ProtocolSerializationException ex)
      {
      }
        
      return byteStream.toByteArray();
   }
   
   public void registerRequestBytes(byte[] request)
   {
      this.expectedRequest = request;
   }
   
   public void registerResponseBytes(byte[] response)
   {
      this.expectedResponse = response;
   }
   
   private void printBytes(byte[] bytes, PrintStream out)
   {
      out.print("{");
      for(int a=0; a<bytes.length; a++)
      {
         out.print(bytes[a]);
         if(a != bytes.length - 1)
         {
            out.print(", ");
         }
      }
      out.println("}");
   }
   
   abstract public Request createRequest();
   abstract public Response createResponse();
   
   @Test
   public void test()
   {
      byte[] actualRequest = this.getMessageBytes(this.createRequest());
      byte[] actualResponse = this.getMessageBytes(this.createResponse());
      
      System.out.println(this.getClass().getSimpleName());
      printBytes(actualRequest, System.out);
      printBytes(actualResponse, System.out);
      
      assertTrue("Invalid request serialization", Arrays.equals(this.expectedRequest, actualRequest));
      assertTrue("Invalid response serialization", Arrays.equals(this.expectedResponse, actualResponse));
   }
}


