//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: vthornton
//
// Date: Sep 6, 2007
//---------------------

package org.cleversafe.layer.grid;

import static org.junit.Assert.fail;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.cleversafe.config.ConfigGenerator;
import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.layer.slicestore.SliceStoreTransaction;
import org.cleversafe.layer.slicestore.exceptions.IllegalSourceNameException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreIOException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreNotFoundException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreQuotaException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreTransactionException;
import org.cleversafe.test.BaseTest;
import org.cleversafe.vault.FullAccountCreator;
import org.cleversafe.vault.Vault;
import org.junit.After;

public abstract class GridBaseTest extends BaseTest
{
   private FullAccountCreator accountCreator;
   protected static String vaultDescriptor = "/vault-descriptor.xml";

   private Vault vault;

   @After
   public void cleanupVault()
   {
      cleanupVault(this.vault);
      this.vault = null;
   }

   public void cleanupVault(Vault vault)
   {
      if (vault != null)
      {
         vault.endSessions();
   
         for (SliceStore sliceStore : vault.getSliceStores())
         {
            try
            {
               sliceStore.deleteStore();
            }
            catch (SliceStoreIOException e)
            {
               e.printStackTrace();
               fail(e.getMessage());
            }
            catch (SliceStoreNotFoundException e)
            {
               e.printStackTrace();
               fail(e.getMessage());
            }
         }      
      }
   }
   
   protected synchronized Vault getVault()
   {
      if (this.vault == null)
      {
         try
         {
            this.vault = createVault();
         }
         catch (Exception e)
         {
            e.printStackTrace();
         }
      }
      
      return this.vault;
   }

   protected Vault createVault() throws Exception
   {
      Vault vault = null;

      try
      {
         File vaultTemplateFile = new File(getInputDirectory() + vaultDescriptor);
         byte[] vaultTemplateBuffer = new byte[(int) vaultTemplateFile.length()];

         InputStream in = new FileInputStream(vaultTemplateFile);
         in.read(vaultTemplateBuffer);
         in.close();

         String vaultTemplate = new String(vaultTemplateBuffer);

         Properties properties = new Properties();
         properties.setProperty("output-directory", getOutputDirectory().getAbsolutePath());
         ConfigGenerator configGenerator =
               new ConfigGenerator(new String(vaultTemplate), properties);

         vaultTemplate = configGenerator.generate();

         BufferedWriter out =
               new BufferedWriter(new FileWriter(getOutputDirectory() + vaultDescriptor));

         out.write(vaultTemplate);
         out.close();

         this.accountCreator = new FullAccountCreator(getOutputDirectory() + vaultDescriptor);
         vault = this.accountCreator.getVault();

         vault.startSessions();
      }
      catch (Exception e)
      {
         e.printStackTrace();
         fail(e.getMessage());
      }

      return vault;
   }
   
   protected void fillSliceStore(Vault vault, int sliceStoreIdx)
         throws SliceStoreTransactionException, SliceStoreIOException, SliceStoreNotFoundException,
         IllegalSourceNameException, SliceStoreQuotaException
   {
      long bytesToWrite = vault.getSliceStoreSize(sliceStoreIdx);
      long requestSourceSize = vault.getMaxSliceSize();

      SliceStore sliceStore = vault.getSliceStores().get(sliceStoreIdx);

      int sourceName = 0;

      List<DataSlice> dataSlices = new ArrayList<DataSlice>();

      byte[] data = new byte[(int) requestSourceSize];

      long transactionId = 0;
      while (bytesToWrite >= requestSourceSize)
      {
         DataSlice dataSlice =
               new DataSlice(new SliceName(String.valueOf(sourceName), 0), transactionId, data);
         dataSlices.add(dataSlice);

         bytesToWrite -= requestSourceSize;
         sourceName++;

         if (dataSlices.size() > 4096)
         {
            SliceStoreTransaction transaction = sliceStore.createTransaction(transactionId);
            sliceStore.beginTransaction(transaction);
            sliceStore.write(dataSlices);
            sliceStore.commitTransaction(transaction);

            dataSlices.clear();
         }
      }

      SliceStoreTransaction transaction = sliceStore.createTransaction(0);
      sliceStore.beginTransaction(transaction);
      sliceStore.write(dataSlices);
      sliceStore.commitTransaction(transaction);
   }
   
}
