package org.cleversafe.vault;

import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.cleversafe.codec.Codec;
import org.cleversafe.ida.InformationDispersalCodec;
import org.cleversafe.ida.exceptions.IDAInvalidParametersException;
import org.cleversafe.layer.slicestore.SliceStore;

/**
 * Simple mock vault
 */
public class MockVault extends BaseVault
{
   private int numWriteFailures;
   private int numReadFailures;
   private Set<Integer> failureIndices;

   private int numCumulativeErrors;
   private int numCumulativeTxInvalid;
   private int numCumulativeCorrupt;

   public MockVault(
         InformationDispersalCodec idaCodec,
         List<Codec> codecs,
         List<Codec> sliceCodecs,
         List<SliceStore> sliceStores,
         int writeThreshold,
         int readThreshold,
         int numWriteFailures,
         int numReadFailures,
         int numCumulativeError,
         int numCumulativeTxInvalid,
         int numCumulativeCorrupt,
         Set<Integer> failureIndices) throws IDAInvalidParametersException
   {
      super("test", idaCodec, codecs, sliceCodecs, sliceStores);

      this.setWriteThreshold(writeThreshold);
      this.setReadThreshold(readThreshold);

      this.numWriteFailures = numWriteFailures;
      this.numReadFailures = numReadFailures;
      this.failureIndices = failureIndices;

      this.numCumulativeErrors = numCumulativeError;
      this.numCumulativeTxInvalid = numCumulativeTxInvalid;
      this.numCumulativeCorrupt = numCumulativeCorrupt;

      this.initialize();
      
      this.setVaultIdentifier(new UUID(0, 0));
   }

   public int getWriteFailures()
   {
      return this.numWriteFailures;
   }

   public int getReadFailures()
   {
      return this.numReadFailures;
   }

   public int getNumCumulativeErrors()
   {
      return this.numCumulativeErrors;
   }

   public int getNumCumulativeTxInvalid()
   {
      return this.numCumulativeTxInvalid;
   }

   public int getNumCumulativeCorrupt()
   {
      return this.numCumulativeCorrupt;
   }

   public String toString()
   {
      return String.format(
            "%d-lose-%d, thresholds=[w=%d, r=%d], failures=[%d, w=%d, r=%d, ce=%d, ct=%d, cc=%d, stores=%s]",
            this.idaCodec.getNumSlices(), this.idaCodec.getNumSlices()
                  - this.idaCodec.getThreshold(), this.writeThreshold, this.readThreshold,
            this.numWriteFailures + this.numReadFailures, this.numWriteFailures,
            this.numReadFailures, this.numCumulativeErrors, this.numCumulativeTxInvalid,
            this.numCumulativeCorrupt, this.failureIndices.toString());
   }

   public long getMaxSliceSize()
   {
      return 0;
   }

   public long getSize()
   {
      return 0;
   }

   public void optimizeVault()
   {
      // Do nothing
   }
}
