//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: mmotwani
//
// Date: Apr 27, 2007
//---------------------

package org.cleversafe.codec;

import java.io.*;
import org.apache.tools.bzip2.*;

public class BZip2Benchmark {
	public static void main(String[] args) throws Exception
	{
		long timeBefore = System.currentTimeMillis();
		
		if( args.length != 2 )
		{
			System.out.println("Invalid number of arguments!");
			System.out.println("usage: java BZip2Benchmark [input file] [output file]");
			System.exit(1);
		}
		
		String inputFilename = args[0];
		String outputFilename = args[1];
		
	    try {
	        // Create the BZip2 output stream
	    	FileOutputStream outFile = new FileOutputStream(outputFilename);
	    	outFile.write(new byte[] {'B','Z'});
	    	CBZip2OutputStream out = new CBZip2OutputStream(outFile);
	    
	        // Open the input file
	        FileInputStream in = new FileInputStream(inputFilename);
	    
	        // Transfer bytes from the input file to the BZip2 output stream
	        byte[] buf = new byte[1024];
	        int len;
	        while ((len = in.read(buf)) > 0) {
	            out.write(buf, 0, len);
	        }
	        in.close();
	    
	        // Complete the BZip2 file
	        //out.finalize();
	        out.close();
	    } catch (IOException e) {
	    	System.out.println( "Error: " + e.getMessage() );
	    	System.exit(1);
	    }
	    
	    long timeAfter = System.currentTimeMillis();
	    
	    System.out.println( "Time taken: " + (timeAfter-timeBefore) + " ms.");
	}
}


