package org.cleversafe.test;



public abstract class IteratedWorkItem extends WorkItem
{
   private long iteration;
   private long iterationCount;
   
   private long iterationBits;
   
   public IteratedWorkItem( long id, double workUnits, long iterationCount )
   {
      super( id, workUnits * iterationCount );
      this.iterationCount = iterationCount;
      
      this.iterationBits = (long) ( Math.ceil( Math.log( iterationCount ) / Math.log( 2 ) ) );
   }

   public void run()
   {
      try
      {
         beforeIterations();
         
         for( iteration = 0; iteration < iterationCount; iteration++ )
         {
            performIteration();
         }
         
         afterIterations();
      } catch ( Exception ex )
      {
         ex.printStackTrace();
      }
   }
   
   public long getIteration()
   {
      return iteration;
   }
   
   public long getIterationId()
   {
      return getId() << iterationBits | iteration;       
   }
   
   public String getIterationIdString()
   {
      return String.valueOf( getIterationId() );      
   }
   
   protected void beforeIterations() throws Exception
   {      
   }
   
   protected void afterIterations() throws Exception
   {      
   }
   
   protected abstract void performIteration() throws Exception;
   
}

