package org.cleversafe.test;


public class PerformanceTestResult
{
   private double executionTime;
   private double workUnitsCompleted;   
   
   public PerformanceTestResult(
      double executionTime, 
      double workUnitsCompleted)
   {
      this.executionTime = executionTime;
      this.workUnitsCompleted = workUnitsCompleted;
   }

   public double getExecutionTime()
   {
      return executionTime;
   }

   public double getWorkUnitsCompleted()
   {
      return workUnitsCompleted;
   }

   public double getWorkUnitsPerSecond()
   {
      return this.workUnitsCompleted/this.executionTime;
   }
   
   public synchronized void add(PerformanceTestResult another)
   {
      this.executionTime += another.executionTime;
      this.workUnitsCompleted += another.workUnitsCompleted;
   }
      
}
