
package org.cleversafe;

import org.apache.log4j.xml.DOMConfigurator;
import org.cleversafe.config.ConfigurationFactory;
import org.cleversafe.serialization.asn1.ASN1Test;
import org.cleversafe.test.BaseTest;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(Suite.class)
@Suite.SuiteClasses({
   ASN1Test.class
})
public class UnitTests
{
   // This class is only used as a holder for the above annotations

   public static void resetConfiguration()
   {
      System.out.println("Working directory: " + System.getProperty("user.dir"));
      System.setProperty("log4j.configuration", "conf/dev/block-device/log4j.xml");
      DOMConfigurator.configure(System.getProperty("log4j.configuration"));
      System.setProperty("org.cleversafe.xml.configuration",
            "conf/dev/core/core-org-bindings.xml;conf/dev/block-device/blockdevice-org-bindings.xml");
      ConfigurationFactory.unloadBindings(ConfigurationFactory.XML_CONFIG_TYPE);
      System.setProperty(BaseTest.TEST_INPUT_PROPERTY, "core-org/test-input");
      System.setProperty(BaseTest.TEST_OUTPUT_PROPERTY, "output/tests");
   }

}
