//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: Jason Resch
//
// Date: Sep 20, 2007
//---------------------

package org.cleversafe.codec;

import java.util.ArrayList;
import java.util.List;

import org.cleversafe.codec.misc.TranspositionCodec;


public class TranspositionCodecTest extends CodecTestBase
{

   public TranspositionCodecTest() throws Exception
   {
      super();
   }
   
   @Override
   public List<Codec> getCodecPermutations() throws Exception
   {
      List<Codec> codecPermutations = new ArrayList<Codec>(9);
      codecPermutations.add(new TranspositionCodec(1));
      codecPermutations.add(new TranspositionCodec(2));
      codecPermutations.add(new TranspositionCodec(5));
      codecPermutations.add(new TranspositionCodec(12));
      codecPermutations.add(new TranspositionCodec(17));
      codecPermutations.add(new TranspositionCodec(100));
      codecPermutations.add(new TranspositionCodec(127));

      codecPermutations.add(new TranspositionCodec(128));
      codecPermutations.add(new TranspositionCodec(255));
      
      // FIXME: These will fail, update transposition codec to 
      // Not accept values greater than 255 or update the padding
      // scheme to allow any length of padding.
      
      //codecPermutations.add(new TranspositionCodec(256));
      //codecPermutations.add(new TranspositionCodec(3000));
      
      return codecPermutations;
   }
   
}
