//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: Jason Resch
//
// Date: Mar 7, 2008
//---------------------

package org.cleversafe.codec.compatibility;

import org.cleversafe.codec.Codec;
import org.cleversafe.codec.integrity.CRCIntegrityCodec;
import org.cleversafe.codec.misc.TranspositionCodec;

public class TranspositionCodecCompatibilityTest extends CodecCompatibilityTestBase
{
   public static final int dataLength = 957;
   public static final byte[] encoded = new byte[] { -42, 120, 127, -6, 60, -32, 9, -33, 57, 110, -29, 83, 32, 7, -22, -58, 55, 99, -39, -110, 81, 8, -69, 47, -97, -56, -109, 11, -75, -105, -43, 17, 107, 39, 73, -40, 92, -22, 83, 9, 114, 29, -60, 37, -49, -67, -79, 110, 49, -114, 100, -70, 45, -58, -49, 80, -5, -2, 11, 110, -77, 121, 64, -97, -37, 39, -4, 46, 40, 97, -42, 27, 97, 69, -22, 95, -15, -124, 60, -54, -20, 36, 4, -46, -125, -43, 31, 89, -23, 40, 67, 16, 86, 85, -90, 89, 34, -119, -101, -68, -55, 126, -110, -88, 66, -98, -117, -105, -87, -17, 73, -27, -3, -12, 85, 29, -87, 101, -7, 20, -40, -92, 75, -16, 93, 3, -16, 2, 88, 92, -115, 6, -18, 9, 60, -4, -93, -18, -15, -108, 122, 72, -22, -17, -32, -39, -25, 56, -83, -40, 24, 110, -36, 45, 36, 126, 46, -123, 119, -108, -120, -102, 41, -31, -122, 8, 63, 114, 26, -108, -63, -109, 49, -78, -93, -123, -16, 112, 110, -61, 23, 114, -15, -92, -78, 15, -39, 57, 39, -124, -105, 38, 78, -120, 13, 72, 80, 77, -113, -44, -50, -18, -38, 8, 54, 116, -62, 108, 36, 123, -36, -102, 21, 114, -17, 126, 42, 79, 69, -26, 41, 98, -24, 78, -95, 73, 80, -29, -28, 26, 41, 64, -107, 51, 99, 59, -125, 26, 29, 126, 100, -116, 13, -25, -35, -120, -83, -62, -14, 87, -19, -93, -74, 64, -2, -62, 26, 99, -111, 118, 67, -2, -49, -99, 46, -26, -75, -24, 30, 13, -28, 76, 15, 102, -75, 58, -114, -46, 49, -10, 12, 123, 101, 41, 17, 1, 96, 50, 13, -11, 32, -120, 22, 46, 127, 111, 39, -118, 83, 66, 90, -26, -79, 98, 49, -19, -92, -116, 8, 76, 35, 83, -49, 111, 122, 86, -44, -17, -70, -38, -71, 45, -104, 29, -104, 102, 48, 30, 122, 43, 123, -85, -107, 40, 31, -36, -95, 34, -42, 80, 96, 76, 79, 78, 68, 92, -118, -43, 81, 63, 99, 125, -103, -94, -65, 43, -128, 98, 39, -93, 103, -12, -114, 68, 78, 7, 41, -5, 35, 11, -108, 36, -43, 22, -1, -10, -80, -50, -48, -101, -60, -92, -64, -45, 120, 112, 86, 40, 18, 104, -45, 26, -83, -96, 81, -70, -58, -17, 81, 24, -50, 89, -128, 4, 39, -4, -78, 40, 90, 11, -41, 92, -68, 56, 123, 119, 110, -34, -25, 76, -23, 87, -122, -79, -125, -23, 0, -78, -79, 19, 8, -60, 37, 115, -56, -18, 64, 95, -34, 35, -42, 86, 103, -124, 13, 23, -67, -66, -107, 88, 50, -71, -33, 71, 124, 118, -113, 89, -107, 42, -81, 25, 98, -69, -119, -52, -44, 111, 108, 44, 74, -99, 75, -93, 0, -83, -107, 111, -36, -10, 92, -24, 9, 40, -14, -117, -102, 112, 61, 125, -90, 123, -50, 22, -118, 73, 59, 92, 92, -68, 17, 105, 31, 45, 56, 82, -15, 89, 122, -18, 96, -24, -22, 124, 95, 89, 94, 103, -63, -85, -119, 98, -107, -82, 9, -107, -40, -111, 57, 45, -107, 79, -87, 8, 94, -19, 46, 119, -68, -120, 3, 33, 54, 113, -56, 29, -24, 33, -100, -62, -18, -78, -108, 89, 37, -106, 44, -62, 40, 35, -111, 31, 43, -7, 46, 6, -83, -111, -114, 66, -92, 44, -122, 85, -49, 67, -115, -63, 65, 19, -84, 117, -43, -36, -70, 0, -49, -32, 34, 73, -38, 88, -102, -88, -72, -48, -97, 40, -114, 27, 120, -121, 6, -36, 125, 91, -60, -110, -30, 7, -8, -25, 100, -100, -17, -28, 100, 108, 55, -128, -38, 33, -78, -88, 72, 116, -72, -68, 34, -70, 77, -128, 71, -112, -37, 109, 118, 63, 14, 93, 127, -10, -85, -14, 64, -34, 13, -14, 8, -106, -72, -82, 41, -77, -81, -115, 113, 64, 83, 35, 31, -104, -2, -105, -58, 94, -26, 7, -96, 86, 3, 13, -81, -69, -81, 57, -115, -4, 3, -49, -107, 114, 107, -102, 109, 66, -80, 124, -81, 80, 54, -92, 16, -111, 113, -12, -47, 119, -77, -106, -45, -104, 38, -109, -106, -2, 3, -1, -34, -125, -116, -94, 92, -81, 125, -10, -89, -34, 2, 52, 89, 51, 31, 68, 101, -16, 49, -69, 72, 54, 105, 49, -13, -17, 14, -50, -54, 103, 68, -111, 75, 6, -123, -109, 82, 30, -4, -4, -83, 55, -34, 97, 94, -52, 32, -62, 28, 62, 10, 55, 97, 78, -23, -72, -87, -46, -81, 70, 79, -62, 37, 64, -42, -117, -67, -56, -85, -85, -38, 30, 119, 110, 41, -118, -109, 70, 107, 116, 44, -76, 107, -94, 75, 17, -17, -13, -2, 101, 50, -59, -80, 123, 126, -26, -32, 127, 113, -12, 123, 84, 85, 5, -26, 22, -112, -54, 70, -44, -35, 115, 68, 6, 46, 16, 29, -2, -18, -121, -43, -96, 47, -126, -84, 64, -87, 98, 26, 111, -19, -64, 57, -21, 51, 83, 50, 10, -118, -82, 2, -59, -5, 21, -117, 88, 122, 45, 125, -49, -101, -23, -111, -27, -36, -55, -95, 59, -57, -31, -123, 38, 22, 41, 1, 102, -114, 75, 125, -40, -124, 63, -82, -6, -25, -61, 14, 17, 23, 86, 22, -65, -72, 84, 12, 38, 101, -128, -86, -87, 121, -63, -124, 72, 116, 91, 123, -25, -79, 51, 17, 29, -126, 32, 61, 107, -9, 93, -70, 32, 66, -23, -38, 30, -70, 96, 45, 33, -119, -119, 113, 27, 71, 75, -97, -78, -71, 3, 19, -10, 68, -65, 50, -8, 70, -102, -17, -4, 75, 3, 91, -85, -49, 50, 5, 10, 59, -85, -78, 47, -31, 3 };

   public TranspositionCodecCompatibilityTest()
   {
      super(encoded, dataLength);
   }
   
   @Override
   public Codec getCodec()
   {
      return new TranspositionCodec(12);
   }
   
}
