//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
// -----------------------
// @author: Dusty Hendrickson
//
// Date: Jun 5, 2008
// ---------------------

package org.cleversafe.codec.header.zero;

import java.util.Arrays;

import org.cleversafe.codec.Decoder;
import org.cleversafe.codec.exceptions.CodecInvalidDataFormatException;
import org.junit.Assert;
import org.junit.Test;

public class ZeroHeaderDecoderTest
{
   @Test
   public void testInvalidDecode() throws Exception
   {
      final Decoder decoder = new ZeroHeaderDecoder();

      final byte[] data = new byte[]{1, 1, 2, 3, 4};

      boolean isError = false;
      try
      {
         decoder.finish(data);
      }
      catch (final CodecInvalidDataFormatException ex)
      {
         System.out.println(ex.getMessage());
         isError = true;
      }

      Assert.assertTrue(isError);
   }

   @Test
   public void testEmptyDecode() throws Exception
   {
      final Decoder decoder = new ZeroHeaderDecoder();

      final byte[] data = new byte[0];

      boolean isError = false;
      try
      {
         decoder.finish(data);
      }
      catch (final CodecInvalidDataFormatException ex)
      {
         System.out.println(ex.getMessage());
         isError = true;
      }

      Assert.assertTrue(isError);
   }

   @Test
   public void testOnlyHeader() throws Exception
   {
      final Decoder decoder = new ZeroHeaderDecoder();

      final byte[] data = new byte[]{0};

      final byte[] decodedData = decoder.finish(data);

      Assert.assertTrue(Arrays.equals(new byte[0], decodedData));
   }

   @Test
   public void testOnlyInvalidHeader() throws Exception
   {
      final Decoder decoder = new ZeroHeaderDecoder();

      final byte[] data = new byte[]{1};

      boolean isError = false;
      try
      {
         decoder.finish(data);
      }
      catch (final CodecInvalidDataFormatException ex)
      {
         System.out.println(ex.getMessage());
         isError = true;
      }

      Assert.assertTrue(isError);
   }

   @Test
   public void testFinish() throws Exception
   {
      final Decoder decoder = new ZeroHeaderDecoder();

      final byte[] data = new byte[]{0, 1, 2, 3, 4};

      final byte[] decodedData = decoder.finish(data);

      Assert.assertTrue(Arrays.equals(new byte[]{1, 2, 3, 4}, decodedData));
   }

   @Test
   public void testProcess() throws Exception
   {
      final Decoder decoder = new ZeroHeaderDecoder();

      final byte[] data1 = new byte[]{0, 1, 2, 3, 4};
      final byte[] data2 = new byte[]{5, 6, 7, 8};

      final byte[] processData = decoder.process(data1);
      final byte[] finishData = decoder.finish(data2);

      Assert.assertTrue(Arrays.equals(new byte[]{1, 2, 3, 4}, processData));
      Assert.assertTrue(Arrays.equals(new byte[]{5, 6, 7, 8}, finishData));

   }

   @Test
   public void testReset() throws Exception
   {
      final Decoder decoder = new ZeroHeaderDecoder();

      final byte[] data1 = new byte[]{0, 1, 2, 3, 4};
      final byte[] data2 = new byte[]{0, 5, 6, 7, 8};

      final byte[] processData = decoder.process(data1);
      decoder.reset(null, 0);
      final byte[] finishData = decoder.finish(data2);

      Assert.assertTrue(Arrays.equals(new byte[]{1, 2, 3, 4}, processData));
      Assert.assertTrue(Arrays.equals(new byte[]{5, 6, 7, 8}, finishData));
   }

   @Test
   public void testInitialized()
   {
      final Decoder decoder = new ZeroHeaderDecoder();

      Assert.assertTrue(decoder.isInitialized());
   }
}
