//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: May 18, 2007
//---------------------

package org.cleversafe.config;

import static org.junit.Assert.fail;

import org.cleversafe.UnitTests;
import org.cleversafe.test.BaseTest;
import org.cleversafe.test.TestException;
import org.junit.BeforeClass;
import org.junit.Test;

// TODO: Describe class or interface
public class ConfigurationFactoryTest extends BaseTest
{
   static String originalConfigurationProperty;

   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
      UnitTests.resetConfiguration();
   }

   @Test
   public void creationTest() throws TestException
   {
      String prevConfigProperty =
            System.getProperty(ConfigurationFactory.XML_BINDINGS_CONFIG_PROPERTY);
      try
      {
         ;

         System.setProperty(ConfigurationFactory.XML_BINDINGS_CONFIG_PROPERTY, System.getProperty(
               BaseTest.TEST_INPUT_PROPERTY, ".")
               + "/org/cleversafe/config/bindingsTest.xml");
         ConfigurationFactory.unloadBindings(ConfigurationFactory.XML_CONFIG_TYPE);

         try
         {
            BindingsProvider cfg =
                  ConfigurationFactory.getBindingsProvider(ConfigurationFactory.XML_CONFIG_TYPE);

            assert cfg instanceof XMLBindingsProvider;
         }
         catch (Exception e)
         {
            fail("unexpected exception: " + e.getMessage());
         }
      }
      finally
      {
         System.setProperty(ConfigurationFactory.XML_BINDINGS_CONFIG_PROPERTY, prevConfigProperty);
         ConfigurationFactory.unloadBindings(ConfigurationFactory.XML_CONFIG_TYPE);
      }
   }

   @Test
   public void propertyNotDefined()
   {
      String oldVlaue = System.getProperty(ConfigurationFactory.XML_BINDINGS_CONFIG_PROPERTY);
      System.setProperty(ConfigurationFactory.XML_BINDINGS_CONFIG_PROPERTY, "bad/property/value");
      ConfigurationFactory.unloadBindings(ConfigurationFactory.XML_CONFIG_TYPE);
      try
      {
         ConfigurationFactory.getBindingsProvider(ConfigurationFactory.XML_CONFIG_TYPE);
         fail("expected exception: bad/property/value is a bad property");
      }
      catch (Exception e)
      {
      }
      finally
      {
         if (oldVlaue != null)
         {
            System.setProperty(ConfigurationFactory.XML_BINDINGS_CONFIG_PROPERTY, oldVlaue);
            ConfigurationFactory.unloadBindings(ConfigurationFactory.XML_CONFIG_TYPE);
         }
      }
   }
}
