//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: May 13, 2007
//---------------------

package org.cleversafe.config;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.Arrays;
import java.util.List;

import org.apache.log4j.Logger;
import org.cleversafe.config.evaluator.Literal;
import org.cleversafe.config.evaluator.SimpleParameter;
import org.cleversafe.config.evaluator.SupportedTypes;
import org.cleversafe.config.exceptions.ConfigurationException;
import org.cleversafe.config.exceptions.ObjectInstantiationException;
import org.junit.Test;

// TODO: Describe class or interface
public class InterfaceImplementationFactoryTest
{
   private static Logger _logger = Logger.getLogger(InterfaceImplementationFactoryTest.class);

   static public interface TestI
   {
      long sum();

      double dimSum();

      public byte getByteP();

      int getIntP();

      public char getCharP();

      public double getDoubleP();

      public long getLongP();

      public short getShortP();

      public String getStr();
   }

   static public class TestA implements TestI
   {
      private int intP;
      private short shortP;
      private long longP;
      private byte byteP;
      private float floatP;
      private double doubleP;
      private char charP;
      private String str;

      public byte getByteP()
      {
         return this.byteP;
      }

      public void setByteP(byte byteP)
      {
         this.byteP = byteP;
      }

      public char getCharP()
      {
         return this.charP;
      }

      public void setCharP(char charP)
      {
         this.charP = charP;
      }

      public double getDoubleP()
      {
         return this.doubleP;
      }

      public void setDoubleP(double doubleP)
      {
         this.doubleP = doubleP;
      }

      public float getFloatP()
      {
         return this.floatP;
      }

      public void setFloatP(float floatP)
      {
         this.floatP = floatP;
      }

      public int getIntP()
      {
         return this.intP;
      }

      public void setIntP(int intP)
      {
         this.intP = intP;
      }

      public long getLongP()
      {
         return this.longP;
      }

      public void setLongP(long longP)
      {
         this.longP = longP;
      }

      public short getShortP()
      {
         return this.shortP;
      }

      public void setShortP(short shortP)
      {
         this.shortP = shortP;
      }

      public String getStr()
      {
         return this.str;
      }

      public void setStr(String str)
      {
         this.str = str;
      }

      public long sum()
      {
         return this.byteP + this.shortP + this.intP + this.longP;
      }

      public double dimSum()
      {
         return this.floatP + this.doubleP;
      }
   }

   private SimpleParameter createSimpleParameter(String name, SupportedTypes.Enum type, String value)
   {
      SimpleParameter param = SimpleParameter.Factory.newInstance();
      Literal literal = param.addNewLiteral();
      literal.setValue(value);
      literal.setType(type);
      param.setName(name);
      return param;
   }

   @Test
   public void testImplementationFactory0()
   {
      try
      {
         List<SimpleParameter> params =
               Arrays.asList(new SimpleParameter[]{
                     createSimpleParameter("intP", SupportedTypes.INT, "1"),
                     createSimpleParameter("shortP", SupportedTypes.SHORT, "2"),
                     createSimpleParameter("longP", SupportedTypes.LONG, "3"),
                     createSimpleParameter("byteP", SupportedTypes.BYTE, "4"),
                     createSimpleParameter("floatP", SupportedTypes.FLOAT, "10.1"),
                     createSimpleParameter("doubleP", SupportedTypes.DOUBLE, "12.2"),
                     createSimpleParameter("str", SupportedTypes.STRING, "my string"),
               });
         InterfaceImplementationFactory f =
               new InterfaceImplementationFactory(
                     InterfaceImplementationFactoryTest.class.getName() + "$TestI",
                     InterfaceImplementationFactoryTest.class.getName() + "$TestA", params);
         TestI t = (TestI) f.getInterfaceImplementation();
         assertTrue(t.sum() == 10);
         assertEquals(t.getStr(), "my string");
         t.dimSum();
         assertTrue(t.dimSum() < 22.3001);
         assertTrue(t.dimSum() > 22.2999);
      }
      catch (Exception e)
      {
         e.printStackTrace();
         fail("Unexpected exception:" + e);
      }
   }

   @Test(expected = ClassNotFoundException.class)
   public void testImplementationFactory1() throws ClassNotFoundException,
         ObjectInstantiationException
   {
      new InterfaceImplementationFactory("org.cleversafe.config.ImplementationFactoryTest$Testxxx",
            "org.cleversafe.config.ImplementationFactoryTest$TestA", null);
   }

   @Test(expected = ClassNotFoundException.class)
   public void testImplementationFactory2() throws ClassNotFoundException,
         ObjectInstantiationException
   {
      new InterfaceImplementationFactory("org.cleversafe.config.ImplementationFactoryTest$TestI",
            "org.cleversafe.config.ImplementationFactoryTest$TestAxxx", null);
   }

   @Test
   public void testImplementationFactory3()
   {
      try
      {
         List<SimpleParameter> params = Arrays.asList(new SimpleParameter[]{
            createSimpleParameter("intP", SupportedTypes.INT, "a")
         });

         InterfaceImplementationFactory f =
               new InterfaceImplementationFactory(
                     InterfaceImplementationFactoryTest.class.getName() + "$TestI",
                     InterfaceImplementationFactoryTest.class.getName() + "$TestA", params);
         f.getInterfaceImplementation();
         fail("Expected a ConfigurationException");

      }
      catch (ClassNotFoundException ex)
      {
         fail("Expected a ConfigurationException (not this one)");
      }
      catch (ConfigurationException ce)
      {
         _logger.debug("Expected exception", ce);
      }
   }

   @Test(expected = IllegalArgumentException.class)
   public void testImplementationFactory4() throws ObjectInstantiationException,
         ClassNotFoundException
   {
      new InterfaceImplementationFactory("java.lang.Iterable",
            InterfaceImplementationFactoryTest.class.getName() + "$TestA", null);
   }

}
