//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Dec 8, 2007
//---------------------

package org.cleversafe.control;

import org.junit.Test;
import static org.junit.Assert.*;

public class IntegerParameterTests
{
   @Test
   public void functionalTest()
   {
      IntegerParameter s1 = new IntegerParameter(5);
      assertEquals(5, s1.getStateValue());
      
      assertEquals(6, ((IntegerParameter)s1.advance()).getStateValue());
      assertEquals(4, ((IntegerParameter)s1.reverse()).getStateValue());
      
      assertEquals(s1, s1.advance().reverse());
      assertEquals(s1, s1.reverse().advance());
      
      assertTrue (s1.compareTo(s1.advance()) < 0);
      assertTrue (s1.compareTo(s1.reverse()) > 0);
      assertTrue (s1.compareTo(s1.advance().reverse()) == 0);
      assertTrue (s1.compareTo(s1.reverse().advance()) == 0);
   }
   
   @Test
   public void withinRangeTest()
   {
      IntegerRangeParameter s1 = new IntegerRangeParameter(5, 0, 10);
      assertEquals(5, s1.getStateValue());
      
      assertEquals(6, ((IntegerParameter)s1.advance()).getStateValue());
      assertEquals(4, ((IntegerParameter)s1.reverse()).getStateValue());
      
      assertEquals(s1, s1.advance().reverse());
      assertEquals(s1, s1.reverse().advance());
      
      assertTrue (s1.compareTo(s1.advance()) < 0);
      assertTrue (s1.compareTo(s1.reverse()) > 0);
      assertTrue (s1.compareTo(s1.advance().reverse()) == 0);
      assertTrue (s1.compareTo(s1.reverse().advance()) == 0);
   }
   
   @Test
   public void constructionErrorTest()
   {
      
      try {
         new IntegerRangeParameter(5, 10, 6);
         fail ("initial value greater then max failed");
      }
      catch (IllegalArgumentException x){}
      
      try {
         new IntegerRangeParameter(5, 6, 10);
         fail ("initial value less then min failed");
      }
      catch (IllegalArgumentException x){}
      try {
         new IntegerRangeParameter(11, 6, 10);
         fail ("initial value greater then max failed");
      }
      catch (IllegalArgumentException x){}
   }
   
   @Test
   public void limitRangeTest()
   {
      IntegerRangeParameter s1 = new IntegerRangeParameter(1, 0, 10);
      assertEquals(1, s1.getStateValue());
      assertEquals(0, ((IntegerRangeParameter)s1.reverse()).getStateValue());
      assertEquals(0, ((IntegerRangeParameter)s1.reverse().reverse()).getStateValue());
   }
   
   @Test
   public void equalsTest()
   {
      IntegerRangeParameter s1 = new IntegerRangeParameter(5, 0, 10);
      IntegerParameter s2 = new IntegerParameter(5);
      
      assertEquals(s1.getStateValue(), s2.getStateValue());
      assertNotSame(s1, s2);
      assertNotSame(s2, s1);
   }
   
   @Test
   public void compareTest()
   {
      IntegerRangeParameter s1 = new IntegerRangeParameter(5, 0, 10);
      IntegerParameter s2 = new IntegerParameter(6);
      
      assertTrue(s1.getStateValue() < s2.getStateValue());
      try {
         assertTrue(s1.compareTo(s2) > 0);
         fail ("Can't compare different types");
      }
      catch (IllegalArgumentException ex){}

      try {
         assertTrue(s2.compareTo(s1) > 0);
         fail ("Can't compare different types");
      }
      catch (IllegalArgumentException ex){}
   }
   
}


