//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: dhendrickson
//
// Date: May 29, 2007
//---------------------

package org.cleversafe.layer.protocol;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.UUID;

import org.cleversafe.layer.protocol.GridProtocolOperation;
import org.cleversafe.layer.protocol.PasswordAuthenticationRequest;
import org.junit.Test;


/**
 * A test of the PasswordAuthenticationRequest object.  Tests username, 
 * password, and operation funcionality.
 *
 * @see PasswordAuthenticationRequest
 * @author Dusty Hendrickson
 */
public class PasswordAuthenticationRequestTest
{
   /**
    * Tests that the proper operation type was set in the constructor.
    */
   @Test
   public void testOperation()
   {
      PasswordAuthenticationRequest request = new PasswordAuthenticationRequest();

      GridProtocolOperation operation = (GridProtocolOperation)request.getOperation();

      assertEquals("Unexpected operation", GridProtocolOperation.PASSWORD_AUTHENTICATION_REQUEST, operation);
   }

   @Test
   public void testConstructor()
   {
      UUID testGridAccountID = new UUID(0,0);
      
      PasswordAuthenticationRequest request = new PasswordAuthenticationRequest("username",
                                                                                "password",
                                                                                testGridAccountID);
      
      assertEquals("Username does not match", "username", request.getUsername());
      assertEquals("Password does not match", "password", request.getPassword());
      assertEquals("Grid account ID does not match", testGridAccountID, request.getGridAccountID());
   }
   
   /**
    * Tests that the set/get username functionality is correct.
    */
   @Test
   public void testUsername()
   {
      PasswordAuthenticationRequest request = new PasswordAuthenticationRequest();

      request.setUsername("username");
      String username = request.getUsername();

      assertEquals("Username does not match", "username", username);
   }

   /**
    * Tests that the set/get password functionality is correct.
    */
   @Test
   public void testPassword()
   {
      PasswordAuthenticationRequest request = new PasswordAuthenticationRequest();

      request.setPassword("password");
      String password = request.getPassword();

      assertEquals("Password does not match", "password", password);
   }

   /**
    * Tests that the set/get grid account ID functionality is correct.
    */
   @Test
   public void testGridAccountID()
   {
      PasswordAuthenticationRequest request = new PasswordAuthenticationRequest();

      UUID testGridAccountID = new UUID(0,0);
      
      request.setGridAccountID(testGridAccountID);
      UUID gridAccountID = request.getGridAccountID();

      assertEquals("Grid account ID does not match", testGridAccountID, gridAccountID);
   }
   
   /**
    * Tests that a null grid account ID is handled properly.
    */
   @Test
   public void testNullGridAccountID()
   {
      PasswordAuthenticationRequest request = new PasswordAuthenticationRequest();

      boolean error = false;
      
      try
      {
         request.setGridAccountID(null);
      }
      catch(RuntimeException ex)
      {
         ex.printStackTrace();
         error = true;
      }
      
      assertTrue("Expected exception did not occur", error);
      
      UUID gridAccountID = request.getGridAccountID();
      
      assertEquals("Grid account ID not default value", 
                   "00000000-0000-0000-0000-000000000000",
                   gridAccountID.toString());
   }
}
