//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: dhendrickson
//
// Date: May 29, 2007
//---------------------

package org.cleversafe.layer.protocol;

import static org.junit.Assert.assertEquals;

import org.cleversafe.layer.protocol.GridProtocolOperation;
import org.cleversafe.layer.protocol.PasswordAuthenticationResponse;
import org.junit.Test;


/**
 * A test of the PasswordAuthenticationResponse object.  Tests authenticated 
 * and operation funcionality.
 *
 * @see PasswordAuthenticationResponse
 * @author Dusty Hendrickson
 */
public class PasswordAuthenticationResponseTest
{
   /**
    * Tests that the proper operation type was set in the constructor.
    */
   @Test
   public void testOperation()
   {
      PasswordAuthenticationResponse response = new PasswordAuthenticationResponse();

      GridProtocolOperation operation = (GridProtocolOperation) response.getOperation();

      assertEquals("Unexpected operation", GridProtocolOperation.PASSWORD_AUTHENTICATION_RESPONSE, operation);
   }

   /**
    * Tests that the set/get authenticated functionality is correct.
    */
   @Test
   public void testAuthenticated()
   {
      PasswordAuthenticationResponse response = new PasswordAuthenticationResponse();

      response.setAuthenticated(true);
      boolean authenticated = response.getAuthenticated();

      assertEquals("Authenticated does not match", true, authenticated);
   }
}
