//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: Jason Resch
//
// Date: Jul 19, 2007
//---------------------

package org.cleversafe.layer.slicestore;

import static org.junit.Assert.assertEquals;

import java.util.Random;

import org.cleversafe.layer.grid.DataSlice;
import org.cleversafe.layer.grid.SliceName;
import org.junit.Before;
import org.junit.Test;

// Tests the SliceBuffer Class
public class DataSliceTest
{
   private DataSlice dataSlice;
   private long transactionID;
   private byte[] data;
   private SliceName sliceName;

   @Before
   public void setUp()
   {
      Random rand = new Random();
      rand.setSeed(123); // Intentional repeatability

      this.transactionID = rand.nextLong();
      this.data = new byte[4096];
      rand.nextBytes(this.data);

      this.sliceName = new SliceName("my slice", 4);

      this.dataSlice = new DataSlice(this.sliceName, this.transactionID, this.data);
   }

   @Test
   public void testGetTransactionID()
   {
      long id = this.dataSlice.getTransactionId();
      assertEquals(this.transactionID, id);
   }

   @Test
   public void testGetData()
   {
      byte[] buff = this.dataSlice.getData();

      assertEquals(this.data.length, buff.length);

      for (int itr = 0; itr < buff.length; itr++)
      {
         assertEquals(this.data[itr], buff[itr]);
      }
   }

   @Test
   public void testGetSliceName()
   {
      assertEquals(this.dataSlice.getSliceName(), this.sliceName);
   }

}
