//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: Jul 4, 2007
//---------------------

package org.cleversafe.layer.slicestore.block;

import java.io.File;
import java.util.UUID;

import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.layer.slicestore.SliceStoreBase;
import org.cleversafe.layer.slicestore.SliceStoreTestBase;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreExistsException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreIOException;
/**
 * Used to tst the BlockFile Slice Store implementation
 * 
 * @see SliceStoreTestBase
 */
public class BlockFileSliceStoreTest extends SliceStoreTestBase
{

   private static final String OUTPUT_PATH =
         System.getProperty("org.cleversafe.test-output", ".")
               + "/org/cleversafe/slice/block-file/output/";

   @Override
   public SliceStore getSliceStore()
   {
      // Create Slice Store and start a session
      File dbFile = new File(OUTPUT_PATH); // Must be a directory

      // Ensure directory is empty before running test
      deleteDirectory(dbFile);

      return new BlockFileSliceStore(new UUID(0, 0), System.getProperty(
            "org.cleversafe.test-input", ".")
            + "/org/cleversafe/slice/block/data");
   }

   @Override
   protected void createStore() throws SliceStoreExistsException, SliceStoreIOException
   {
      this.sliceStore.createStore("block", 8192, SliceStoreBase.SLICE_STORE_SIZE_UNLIMITED, // 100MB
            this.vaultACL, null);
   }

   private static boolean deleteDirectory(File dir)
   {
      if (dir.isDirectory())
      {
         String[] children = dir.list();
         for (int i = 0; i < children.length; i++)
         {
            boolean success = deleteDirectory(new File(dir, children[i]));

            if (!success)
            {
               return false;
            }
         }
      }

      // The directory is now empty so delete it
      return dir.delete();
   }

}
