//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: Apr 29, 2007
//---------------------

package org.cleversafe.serialization.asn1;

import static org.junit.Assert.assertEquals;

import java.util.Arrays;

import org.cleversafe.serialization.GridSerializable;
import org.junit.Test;

// TODO: Describe class or interface
public class ASN1TestTestArray
{
   static public class OtherClass implements GridSerializable
   {
      private int intN = 0;
      private boolean boolN = false;

      public OtherClass()
      {
      }

      public OtherClass(int intN, boolean boolN)
      {
         this.intN = intN;
         this.boolN = boolN;
      }

      public boolean equals(OtherClass o)
      {
         return this.intN == o.intN && this.boolN == o.boolN;
      }

      public String toString()
      {
         return "" + intN + "," + boolN;
      }

      public boolean isBoolN()
      {
         return boolN;
      }

      public void setBoolN(boolean boolN)
      {
         this.boolN = boolN;
      }

      public int getIntN()
      {
         return intN;
      }

      public void setIntN(int intN)
      {
         this.intN = intN;
      }
   }
   public static class TestClass implements GridSerializable
   {
      private byte byteP;
      private OtherClass[] nestedC;
      private int intP;

      public int getByteO()
      {
         return intP;
      }

      public void setByteO(int intP)
      {
         this.intP = intP;
      }

      public byte getByteP()
      {
         return byteP;
      }

      public void setByteP(byte byteP)
      {
         this.byteP = byteP;
      }

      public OtherClass[] getNestedC()
      {
         return nestedC;
      }

      public void setNestedC(OtherClass[] nestedC)
      {
         this.nestedC = nestedC;
      }

      public TestClass(byte byteP, int intP, OtherClass[] nestedC)
      {
         this.byteP = byteP;
         this.intP = intP;
         this.nestedC = nestedC;
      }

      public boolean equals(Object other)
      {
         TestClass testClass = (TestClass) other;
         if (nestedC.length != testClass.nestedC.length)
            return false;
         for (int i = 0; i < nestedC.length; i++)
         {
            if (!nestedC[i].equals(testClass.nestedC[i]))
               return false;
         }
         if (byteP == testClass.byteP && intP == testClass.intP)
            return true;
         return false;
      }

      public String toString()
      {
         return byteP + "," + intP + Arrays.toString(nestedC);
      }
   }

   @Test
   public void testEncodeDecode()
   {
      try
      {
         // Instantiate the first test class
         TestClass testClass1 = new TestClass((byte) 1, 25, new OtherClass[]{
               new OtherClass(1, true), new OtherClass(2, false), new OtherClass(3, true),
         });
         System.out.println(testClass1);
         // Produce ASN.1 encoded byte stream
         byte[] encodedBytes = ASN1.DERConverter.encode(testClass1);
         TestClass testClass2 = new TestClass((byte) 0, 0, new OtherClass[]{});
         System.out.println(testClass2);

         ASN1.DERConverter.decode(testClass2, encodedBytes);

         // Check if the first class is equal to the second class
         System.out.println(testClass2);
         assertEquals(testClass1, testClass2);
      }
      catch (Exception ex)
      {
         ex.printStackTrace();
      }
   }
}
