//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: Jun 26, 2007
//---------------------

package org.cleversafe.serialization.asn1;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotSame;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSequence;
import org.cleversafe.test.BaseTest;
import org.junit.BeforeClass;
import org.junit.Test;

// TODO: Describe class or interface
public class ExceptionRegistratorTest
{
   public static class RegisteredException extends Exception
   {
      private static final long serialVersionUID = 1L;
      int index;

      public RegisteredException()
      {
         this.index = 0;
      }

      public RegisteredException(int x)
      {
         this.index = x;
      }

      public int getIndex()
      {
         return this.index;
      }

      public void setIndex(int index)
      {
         this.index = index;
      }
   }

   public static class NonRegisteredException extends Exception
   {
      private static final long serialVersionUID = 1L;

   }

   static public ASN1Object e1(RegisteredException ex)
   {
      return new DERInteger(ex.index);
   }

   static public void d1(RegisteredException ex, ASN1Object obj)
   {
      ex.index = ((DERInteger) obj).getValue().intValue();
   }

   @BeforeClass
   public static void setup()
   {
      System.setProperty(ExceptionRegistrator.ERROR_DEFINITION_PROPERTY, System.getProperty(
            BaseTest.TEST_INPUT_PROPERTY, ".")
            + "/org/cleversafe/serialization/asn1/test-definition.xml");
      ASN1ExceptionWrapper.clearRegistry();
      ExceptionRegistrator.loadAndRegister();
   }

   @Test
   public void registerException()
   {
      ASN1ExceptionWrapper wrapperExc = new ASN1ExceptionWrapper(new RegisteredException(1));
      DERSequence seq = ASN1ExceptionWrapper.encodeException(wrapperExc);

      ASN1ExceptionWrapper nex = new ASN1ExceptionWrapper();
      ASN1ExceptionWrapper.decodeException(nex, seq);

      assertEquals(nex.getOriginalException().getClass(), RegisteredException.class);
   }

   @Test(expected = RuntimeException.class)
   // test registered exceotuion restored to it original type
   public void registerDuplicate()
   {
      ASN1ExceptionWrapper.registerException("Test2", RegisteredException.class);
   }

   @Test(expected = RuntimeException.class)
   public void registerNotUniqueName()
   {
      ASN1ExceptionWrapper.registerException("Test1", NonRegisteredException.class);
   }

   @Test
   // make sure that non registered exception is created as Exception
   public void nonregisterException()
   {
      ASN1ExceptionWrapper wrapperExc = new ASN1ExceptionWrapper(new NonRegisteredException());
      DERSequence seq = ASN1ExceptionWrapper.encodeException(wrapperExc);

      ASN1ExceptionWrapper nex = new ASN1ExceptionWrapper();
      ASN1ExceptionWrapper.decodeException(nex, seq);

      assertNotSame(nex.getOriginalException().getClass(), NonRegisteredException.class);
      assertEquals(nex.getOriginalException().getClass(), Exception.class);
   }

   @Test
   // roundtrip test
   public void serializeTest()
   {
      try
      {
         ASN1ExceptionWrapper wrapperExc = new ASN1ExceptionWrapper(new RegisteredException(99));
         byte[] serializedException = ASN1.DERConverter.encode(wrapperExc);
         ASN1ExceptionWrapper restoredWrapperExc =
               new ASN1ExceptionWrapper(new RegisteredException(0));
         ASN1.DERConverter.decode(restoredWrapperExc, serializedException);
         assertTrue(restoredWrapperExc.getOriginalException() instanceof RegisteredException);
         assertEquals(((RegisteredException) restoredWrapperExc.getOriginalException()).getIndex(),
               99);
      }
      catch (Exception ex)
      {
         fail("Unexpected exception");
      }
   }

}
