//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Sep 7, 2007
//---------------------

package org.cleversafe.serialization.asn1.custom;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.bouncycastle.asn1.ASN1Object;
import org.cleversafe.layer.grid.DataSlice;
import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.serialization.asn1.custom.DataSliceSerialization;
import org.junit.BeforeClass;
import org.junit.Test;

public class DataSliceSerializationTest
{
   private static DataSliceSerialization serialization;

   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
      DataSliceSerializationTest.serialization = new DataSliceSerialization();
   }

   @Test
   public void testGetSerializationClass()
   {
      assertEquals(DataSliceSerializationTest.serialization.getSerializableClass(),
            DataSlice.class);
   }

   @Test
   public void testGetEncodeMethod() throws NoSuchMethodException
   {
      assertEquals(DataSliceSerializationTest.serialization.getEncodeMethod(),
            DataSliceSerialization.class.getMethod("encodeDataSlice", new Class[]{
               DataSlice.class
            }));
   }

   @Test
   public void testGetDecodeMethod() throws NoSuchMethodException
   {
      assertEquals(DataSliceSerializationTest.serialization.getDecodeMethod(),
            DataSliceSerialization.class.getMethod("decodeDataSlice", new Class[]{
                  DataSlice.class, ASN1Object.class
            }));
   }

   @Test
   public void testEncodeDecodeDataSlice1()
   {
      DataSlice dataSlice = new DataSlice();
      ASN1Object asnObj = DataSliceSerialization.encodeDataSlice(dataSlice);

      DataSlice returnedDataSlice = new DataSlice();
      DataSliceSerialization.decodeDataSlice(returnedDataSlice, asnObj);

      assertTrue(dataSlice.equals(returnedDataSlice));
   }

   @Test
   public void testEncodeDecodeDataSlice2()
   {
      DataSlice dataSlice = new DataSlice(new SliceName("My slice name", 6));
      ASN1Object asnObj = DataSliceSerialization.encodeDataSlice(dataSlice);

      DataSlice returnedDataSlice = new DataSlice();
      DataSliceSerialization.decodeDataSlice(returnedDataSlice, asnObj);

      assertTrue(dataSlice.equals(returnedDataSlice));
   }

   @Test
   public void testEncodeDecodeDataSlice3()
   {
      SliceName name = new SliceName("My slice name", 6);
      byte[] data = new byte[256];
      randomizeBuffer(data);
      DataSlice dataSlice = new DataSlice(name, 333, data);
      ASN1Object asnObj = DataSliceSerialization.encodeDataSlice(dataSlice);

      DataSlice returnedDataSlice = new DataSlice();
      DataSliceSerialization.decodeDataSlice(returnedDataSlice, asnObj);

      assertTrue(dataSlice.equals(returnedDataSlice));
   }

   private static void randomizeBuffer(byte buffer[])
   {
      for (int idx = 0; idx < buffer.length; idx++)
      {
         byte value = (byte) (Math.random() * 256);
         buffer[idx] = value;
      }
   }
}
