//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Sep 7, 2007
//---------------------

package org.cleversafe.serialization.asn1.custom;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.HashMap;

import org.bouncycastle.asn1.ASN1Object;
import org.cleversafe.layer.grid.SourceName;
import org.cleversafe.serialization.asn1.custom.SourceNameSerialization;
import org.junit.BeforeClass;
import org.junit.Test;

public class SourceNameSerializationTest
{
   private static SourceNameSerialization serialization;

   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
      SourceNameSerializationTest.serialization = new SourceNameSerialization();
   }

   @Test
   public void testGetSerializationClass()
   {
      assertEquals(SourceNameSerializationTest.serialization.getSerializableClass(),
            SourceName.class);
   }

   @Test
   public void testGetEncodeMethod() throws NoSuchMethodException
   {
      assertEquals(SourceNameSerializationTest.serialization.getEncodeMethod(),
            SourceNameSerialization.class.getMethod("encodeSourceName", new Class[]{
               SourceName.class
            }));
   }

   @Test
   public void testGetDecodeMethod() throws NoSuchMethodException
   {
      assertEquals(SourceNameSerializationTest.serialization.getDecodeMethod(),
            SourceNameSerialization.class.getMethod("decodeSourceName", new Class[]{
                  SourceName.class, ASN1Object.class
            }));
   }

   @Test
   public void testEncodeDecodeSourceName1()
   {
      SourceName sourceName = new SourceName();
      ASN1Object asnObj = SourceNameSerialization.encodeSourceName(sourceName);

      SourceName returnedSourceName = new SourceName();
      SourceNameSerialization.decodeSourceName(returnedSourceName, asnObj);

      assertTrue(sourceName.equals(returnedSourceName));
   }

   @Test
   public void testEncodeDecodeSourceName2()
   {
      SourceName sourceName = new SourceName("Test source name");
      ASN1Object asnObj = SourceNameSerialization.encodeSourceName(sourceName);

      SourceName returnedSourceName = new SourceName();
      SourceNameSerialization.decodeSourceName(returnedSourceName, asnObj);

      assertTrue(sourceName.equals(returnedSourceName));
   }

   @Test
   public void testEncodeDecodeSourceName3()
   {
      SourceName sourceName = new SourceName("Test source name", new HashMap<String, String>());
      ASN1Object asnObj = SourceNameSerialization.encodeSourceName(sourceName);

      SourceName returnedSourceName = new SourceName();
      SourceNameSerialization.decodeSourceName(returnedSourceName, asnObj);

      assertTrue(sourceName.equals(returnedSourceName));
   }

   @Test
   public void testEncodeDecodeSourceName4()
   {
      HashMap<String, String> namedExtensions = new HashMap<String, String>();
      namedExtensions.put("abc", "abcdef");
      namedExtensions.put("what", "hello there");
      namedExtensions.put("this", "is a test");
      SourceName sourceName = new SourceName("Test source name", namedExtensions);
      ASN1Object asnObj = SourceNameSerialization.encodeSourceName(sourceName);

      SourceName returnedSourceName = new SourceName();
      SourceNameSerialization.decodeSourceName(returnedSourceName, asnObj);

      assertTrue(sourceName.equals(returnedSourceName));
   }
}
