//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: May 25, 2007
//---------------------

package org.cleversafe.server.handlers.authentication;

import static org.junit.Assert.assertEquals;

import java.util.List;

import org.cleversafe.layer.protocol.PasswordAuthenticationRequest;
import org.cleversafe.server.ApplicationType;
import org.cleversafe.server.handlers.authentication.PasswordAuthenticationHandler;
import org.junit.Test;


/**
 * A test of the PasswordAuthenticationHandler that focuses on the non-service() methods.  The 
 * service() method is tested in separate unit tests specific to a particular JAAS LoginModule
 * of interest (i.e. Kerbereros, AlwaysAuthenticate, PAM, etc.).
 * 
 * @see PasswordAuthenticationHandler
 * @author Dusty Hendrickson
 */
public class PasswordAuthenticationHandlerTest
{
   /**
    * Confirms that the getAllowedApplications() method only returns APPLICATION_TYPE_ANY.
    *
    * @see ApplicationType
    */
   @Test
   public void testAllowedApplications()
   {
      PasswordAuthenticationHandler authHandler = new PasswordAuthenticationHandler(null, null);
      
      List<ApplicationType> applications = authHandler.getAllowedApplications();
      
      assertEquals("Application list should only contain 1 entry", 1, applications.size());
      assertEquals("Application list should contain TYPE_UNAUTHENTICATED",
                   ApplicationType.TYPE_ANY,applications.get(0));
   }
   
   /**
    * Confirms that the getRequestClass() method returns class type PasswordAuthenticationRequest.
    *
    * @see PasswordAuthenticationRequest.
    */
   @Test
   public void testRequestClass()
   {
      PasswordAuthenticationHandler authHandler = new PasswordAuthenticationHandler(null, null);
      
      Class<?> requestClass = authHandler.getRequestClass();
      
      assertEquals("Invalid Request class", PasswordAuthenticationRequest.class, requestClass);
   }
}
