//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: gdhuse
//
// Date: Apr 27, 2008
//---------------------

package org.cleversafe.util;

import java.util.Set;

import org.apache.log4j.Logger;
import org.junit.Test;

public class NChooseRTest
{
   private static Logger _logger = Logger.getLogger(NChooseRTest.class);

   /**
    * Test of multiple scenarios
    */
   @Test
   public void ncrTest()
   {
      NChooseR[] ncrs =
            new NChooseR[]{
                  new NChooseR(8, 1), new NChooseR(8, 2), new NChooseR(8, 3), new NChooseR(1, 1),
                  new NChooseR(4, 4), new NChooseR(4, 3), new NChooseR(1, 0),
            };

      for (NChooseR ncr : ncrs)
      {
         _logger.info(ncr.toString());
         Set<Integer> perm = ncr.next();
         while (perm != null)
         {
            _logger.info(perm.toString());
            perm = ncr.next();
         }
      }
   }
}
