//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Aug 5, 2007
//---------------------

package org.cleversafe.util;

import static org.junit.Assert.assertFalse;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.junit.Test;

// TODO: Describe class or interface
public class TransactionIdGeneratorTest
{
   private static final int THREAD_NUMBER = 10;
   protected static final int NUMBER_ITERATION = 10;

   @Test
   public void simpleTestGenerator()
   {
      long id1 = TransactionIdGenerator.generate();
      System.out.println("1. " + id1);
      long id2 = TransactionIdGenerator.generate();
      long id3 = TransactionIdGenerator.generate();
      System.out.println("2. " + id2);
      System.out.println("3. " + id3);
      assertFalse(id1 == id2);
      assertFalse(id1 == id3);
      assertFalse(id2 == id3);
   }

   @Test
   public void multipleThreadGenerators()
   {
      System.out.println("Start " + new Date());
      final Map<Integer, long[]> allIds = new HashMap<Integer, long[]>();

      // Start multiple threads and generate ids
      Thread[] threads = new Thread[THREAD_NUMBER];
      for (int i = 0; i < THREAD_NUMBER; i++)
      {
         final int threadId = i;
         threads[i] = new Thread()
         {
            long[] ids = new long[NUMBER_ITERATION];

            public void run()
            {
               for (int j = 0; j < NUMBER_ITERATION; j++)
               {
                  ids[j] = TransactionIdGenerator.generate();
               }
               System.out.println("Thread " + Thread.currentThread().getName() + " finished at "
                     + new Date());
               allIds.put(threadId, ids);
            }
         };
         threads[i].start();
      }
      // Wait until all threads stop
      waitWhileRunning(threads);
      
      // Print ids in order and make sure that none are the same
      int[] currentIndexes = new int[THREAD_NUMBER];
      for (int i=0; i<THREAD_NUMBER; i++) 
      {
         currentIndexes[i] = 0;
      }
      
      Tuple2<Integer, Long> nextValue = null;
      long oldValue = -1;
      while ((nextValue = getNextValue(currentIndexes, allIds)) != null)
      {
         System.out.print("Thread(" + nextValue.getFirst() + ")" + nextValue.getSecond());
         long diff = nextValue.getSecond().longValue() - oldValue;
         if (oldValue > 0) 
         {
            System.out.print(" [" + diff  + "]");
         }
         assertFalse(diff < 1);
         System.out.println();
         oldValue = nextValue.getSecond().longValue();
      }
   }

   private Tuple2<Integer, Long> getNextValue(int[] currentIndexes, Map<Integer, long[]> allIds)
   {
      // Find the next smallest value. 
      // It should be one of running indexes fro each thread
      Tuple2<Integer, Long> retVal = null;
      for (int i=0; i< THREAD_NUMBER; i++) {
         if (currentIndexes[i] < NUMBER_ITERATION) {
            long newVal = allIds.get(i)[currentIndexes[i]];
            if (retVal == null || newVal < retVal.getSecond())
            {
               retVal = new Tuple2<Integer, Long>(i, newVal);
            }
         }
      }
      if (retVal != null) 
      {
         currentIndexes[retVal.getFirst()]++;
      }
      return retVal;
   }

   private void waitWhileRunning(Thread[] threads)
   {
      for (int i = 0; i < THREAD_NUMBER; i++)
      {
         try
         {
            threads[i].join();
         }
         catch (InterruptedException e)
         {
            // TODO Auto-generated catch block
            e.printStackTrace();
         }
      }
   }

}
