//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: May 31, 2007
//---------------------

package org.cleversafe.vault;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import org.bouncycastle.asn1.ASN1Encodable;

/**
 * Contains methods to aid in testing ASN1 object encoding.
 *
 */
public class ASN1ObjectTest
{

   public void dumpBytes( byte[] data )
   {
      dumpBytes(data, 0);
   }
   
   public void dumpBytes( byte[] data, int index )
   {
      Throwable t = new Throwable();
      StackTraceElement elements[] = t.getStackTrace();
      String methodName = elements[2].getMethodName();
      String className = elements[2].getClassName();
      
      try
      {
         FileOutputStream out = new FileOutputStream( 
               className + "." + methodName + "." + Integer.toString(index) + ".dump" );
         out.write( data );
      }
      catch (FileNotFoundException e)
      {
         throw new RuntimeException("unit test error", e);
      }
      catch (IOException e)
      {
         throw new RuntimeException("unit test error", e);
      }
   }
   
   public void dumpObject( ASN1Encodable obj )
   {
      dumpObject(obj, 0);
   }
   
   public void dumpObject( ASN1Encodable obj, int index )
   {
      Throwable t = new Throwable();
      StackTraceElement elements[] = t.getStackTrace();
      String methodName = elements[2].getMethodName();
      String className = elements[2].getClassName();
      
      try
      {
         FileOutputStream out = new FileOutputStream( 
               className + "." + methodName + "." + Integer.toString(index) + ".der" );
         out.write( obj.getDEREncoded() );
      }
      catch (FileNotFoundException e)
      {
         throw new RuntimeException("unit test error", e);
      }
      catch (IOException e)
      {
         throw new RuntimeException("unit test error", e);
      }
   }
   
   
}


