//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: May 25, 2007
//---------------------

package org.cleversafe.vault;

import static org.junit.Assert.*;

import org.cleversafe.vault.VaultPermission;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

// TODO: Describe class or interface
public class VaultPermissionTest
{
  
   private static final String TEST_VAULT_NAME = "test-vault";
   private static VaultPermission READ;
   private static VaultPermission WRITE;
   private static VaultPermission LIST;
   private static VaultPermission REBUILD;
   private static VaultPermission DELETE;
   private static VaultPermission MODIFY_ACL;
   
   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
      READ = new VaultPermission( TEST_VAULT_NAME, VaultPermission.READ );
      WRITE = new VaultPermission( TEST_VAULT_NAME, VaultPermission.WRITE );
      LIST = new VaultPermission( TEST_VAULT_NAME, VaultPermission.LIST );
      REBUILD = new VaultPermission( TEST_VAULT_NAME, VaultPermission.REBUILD );
      DELETE = new VaultPermission( TEST_VAULT_NAME, VaultPermission.DELETE_VAULT );
      MODIFY_ACL = new VaultPermission( TEST_VAULT_NAME, VaultPermission.MODIFY_ACL );
   }

   @AfterClass
   public static void tearDownAfterClass() throws Exception
   {
   }

   @Before
   public void setUp() throws Exception
   {
   }

   @After
   public void tearDown() throws Exception
   {
   }
   
   private void matchActions( String expectedOutput, String input )
   {
      VaultPermission p = new VaultPermission( TEST_VAULT_NAME, input );
      assertEquals( expectedOutput, p.getActions() );
   }
   
   @Test
   public void testReadAction()
   {
      matchActions( "read, list", "read" );
      matchActions( "read, list", "read, list" );
      matchActions( "read, list", "list, read" );
      
      // test with additional permissions
      
      matchActions( "read, list, deleteVault", "read, deleteVault" );
      matchActions( "read, list, deleteVault", "read, list, deleteVault" );
      
      assertTrue( READ.implies(READ) );
      assertTrue( READ.implies(LIST) );
      
      assertTrue( ! READ.implies(WRITE) );
      assertTrue( ! READ.implies(REBUILD) );
      assertTrue( ! READ.implies(DELETE) );
      assertTrue( ! READ.implies(MODIFY_ACL) );
      
      assertEquals( READ, new VaultPermission( TEST_VAULT_NAME, VaultPermission.READ ) );
   }
   
   @Test
   public void testWriteAction()
   {
      matchActions( "read, write, list", "write" );
      matchActions( "read, write, list", "read, write" );
      matchActions( "read, write, list", "write, read" );
      matchActions( "read, write, list", "list, write" );
      matchActions( "read, write, list", "write, list" );
      matchActions( "read, write, list", "read, write, list" );
      matchActions( "read, write, list", "read, write, list" );
      matchActions( "read, write, list", "write, read, list" );
      matchActions( "read, write, list", "write, list, read" );
      matchActions( "read, write, list", "list, read, write" );
      matchActions( "read, write, list", "list, write, read" );
      
      // test with additional permissions
      
      matchActions( "read, write, list, deleteVault", "write, deleteVault" );
      matchActions( "read, write, list, deleteVault", "read, write, list, deleteVault" );
      
      assertTrue( WRITE.implies(READ) );
      assertTrue( WRITE.implies(WRITE) );
      assertTrue( WRITE.implies(LIST) );
      
      assertTrue( ! WRITE.implies(REBUILD) );
      assertTrue( ! WRITE.implies(DELETE) );
      assertTrue( ! WRITE.implies(MODIFY_ACL) );
      
      assertEquals( WRITE, new VaultPermission( TEST_VAULT_NAME, VaultPermission.WRITE ) );
   }
   
   @Test
   public void testListAction()
   {
      matchActions( "list", "list" );
      
      // test with additional permissions
      
      matchActions( "list, deleteVault", "list, deleteVault" );
      matchActions( "list, deleteVault", "deleteVault, list" );
      
      assertTrue( LIST.implies(LIST) );
      
      assertTrue( ! LIST.implies(READ) );
      assertTrue( ! LIST.implies(WRITE) );
      assertTrue( ! LIST.implies(REBUILD) );
      assertTrue( ! LIST.implies(DELETE) );
      assertTrue( ! LIST.implies(MODIFY_ACL) );
      
      assertEquals( LIST, new VaultPermission( TEST_VAULT_NAME, VaultPermission.LIST ) );
   }
   
   @Test
   public void testRebuildAction()
   {
      matchActions( "list, rebuild", "rebuild" );
      matchActions( "list, rebuild", "rebuild, list" );
      matchActions( "list, rebuild", "list, rebuild" );
      
      assertTrue( REBUILD.implies(LIST) );
      assertTrue( REBUILD.implies(REBUILD) );
      
      assertTrue( ! REBUILD.implies(READ) );
      assertTrue( ! REBUILD.implies(WRITE) );
      assertTrue( ! REBUILD.implies(DELETE) );
      assertTrue( ! REBUILD.implies(MODIFY_ACL) );
      
      assertEquals( REBUILD, new VaultPermission( TEST_VAULT_NAME, VaultPermission.REBUILD ) );
   }
   
   @Test
   public void testDeleteAction()
   {
      matchActions( "deleteVault", "deleteVault" );
      
      assertTrue( DELETE.implies(DELETE) );
      
      assertTrue( ! DELETE.implies(READ) );
      assertTrue( ! DELETE.implies(WRITE) );
      assertTrue( ! DELETE.implies(LIST) );
      assertTrue( ! DELETE.implies(REBUILD) );
      assertTrue( ! DELETE.implies(MODIFY_ACL) );
      
      assertEquals( DELETE, new VaultPermission( TEST_VAULT_NAME, VaultPermission.DELETE_VAULT ) );
   }
   
   @Test
   public void testModifyACLAction()
   {
      matchActions( "modifyACL", "modifyACL" );
      
      assertTrue( MODIFY_ACL.implies(MODIFY_ACL) );
      
      assertTrue( ! MODIFY_ACL.implies(READ) );
      assertTrue( ! MODIFY_ACL.implies(WRITE) );
      assertTrue( ! MODIFY_ACL.implies(LIST) );
      assertTrue( ! MODIFY_ACL.implies(REBUILD) );
      assertTrue( ! MODIFY_ACL.implies(DELETE) );
      
      assertEquals( MODIFY_ACL, new VaultPermission( TEST_VAULT_NAME, VaultPermission.MODIFY_ACL ) );
   }
   
   

}


