//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: Jun 16, 2007
//---------------------

package org.cleversafe.vault;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.io.InputStream;
import java.util.UUID;

import org.cleversafe.vault.VaultFileResolver;
import org.junit.Test;

// TODO: Describe class or interface
public class VaultResolverTest
{
   @Test
   public void testproperty()
   {
      
      System.setProperty(VaultFileResolver.VAULT_FILE_LOCATION,
            System.getProperty("org.cleversafe.test-input",".") + "/org/cleversafe/vault");
      UUID vaultId = UUID.fromString("98c3071a-cdd1-48ce-9350-68fad24d7a7d");
      try
      {
         InputStream stream = new VaultFileResolver().getVaultDefinition(vaultId);
         assertNotNull(stream);
      }
      catch (Exception e)
      {
         e.printStackTrace();
         fail("Can't resolve UUID to stream");
      }
      System.setProperty(VaultFileResolver.VAULT_FILE_LOCATION,
            "test-data/org/cleversafe/vaultXXX");
      try
      {
         new VaultFileResolver().getVaultDefinition(vaultId);
         fail("Should fail");
      }
      catch (Exception e)
      {
      }

   }
}
