//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Dec 5, 2007
//---------------------

package org.cleversafe.vault.managers;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.File;
import java.net.URI;
import java.util.UUID;

import org.cleversafe.UnitTests;
import org.cleversafe.exceptions.InitializationException;
import org.cleversafe.util.FileSystemUtils;
import org.cleversafe.vault.VaultManager;
import org.cleversafe.vault.VaultManagerTest;
import org.cleversafe.vault.exceptions.VaultIOException;
import org.cleversafe.vault.managers.state.VaultState;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

// TODO: Describe class or interface
public class LocalFileVaultManagerTest extends VaultManagerTest
{

   
   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
      UnitTests.resetConfiguration();
   }

   @AfterClass
   public static void tearDownAfterClass() throws Exception
   {
   }

   @Override
   @Before
   public void setUp() throws Exception
   {
   }

   @Override
   @After
   public void tearDown() throws Exception
   {
   }
   /**
    * Allows other unit tests to load LOCAL FILE VAULT MANAGER state schema.
    */
   public static void loadDirectory(URI directory) throws VaultIOException
   {
      LocalFileVaultManager.loadDirectory(directory);
   }
   
   /**
    * Allows other unit tests to access LOCAL FILE VAULT MANAGER state schema.
    */
   public static SessionFactory getSessionFactory(URI directory)
   {
      return LocalFileVaultManager.getSessionFactory(directory);
   }
   

   @Override
   public VaultManager getVaultManagerInstance()
   {
      return new LocalFileVaultManager();
   }

   @Test
   public void testCheckInitialization() throws Exception
   {
      LocalFileVaultManager manager = new LocalFileVaultManager();
      try
      {
         manager.checkInitialization();
         fail("Manager initialization check passed; expected failure");
      }
      catch (InitializationException e)
      {
      }

      manager.load(this.getOutputDirectory("testCheckInitialization").toURI());

      try
      {
         manager.checkInitialization();
      }
      catch (InitializationException e)
      {
         fail("Manager initialization check failed; expected passing");
      }
   }

   @Test
   public void testGetVaultFromDatabase() throws Exception
   {
      final File outputDir = this.getOutputDirectory("testGetVaultFromDatabase");
      final URI output = outputDir.toURI();
      FileSystemUtils.deleteDir(outputDir);
      
      LocalFileVaultManager manager = new LocalFileVaultManager();
      manager.load(output);

      UUID vaultIdentifier = UUID.randomUUID();
      String vaultName = "test_name";

      Session session = LocalFileVaultManager.getSessionFactory(output).openSession();
      Transaction tx = session.beginTransaction();

      try
      {
         VaultState vault = new VaultState();
         vault.setIdentifier(vaultIdentifier);
         vault.setName(vaultName);

         session.save(vault);
      }
      finally
      {
         tx.commit();
         session.close();
      }

      session = LocalFileVaultManager.getSessionFactory(output).openSession();
      tx = session.beginTransaction();

      try
      {
         VaultState vault = manager.getVaultFromDatabase(vaultIdentifier, session);
         assertTrue("newly created vault entry not found in database", vault != null);
         assertEquals("VAULT NAME not correct", vaultName, vault.getName());
         assertEquals("VAULT IDENTIFIER not correct", vaultIdentifier, vault.getIdentifier());
      }
      catch (VaultIOException e)
      {
         fail("newly created vault entry not found in database");
      }
      finally
      {
         tx.commit();
         session.close();
      }
   }

}
