//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: mmotwani
//
// Date: Jun 20, 2007
//---------------------

package org.cleversafe.vault.storage.asn1;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.cleversafe.vault.storage.asn1.VaultPermissionEntry;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

// TODO: Describe class or interface
public class VaultPermissionEntryTest
{
   //private static Logger _logger = Logger
   //      .getLogger(VaultPermissionEntryTest.class);
   
   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
   }

   @AfterClass
   public static void tearDownAfterClass() throws Exception
   {
   }

   @Before
   public void setUp() throws Exception
   {
   }

   @After
   public void tearDown() throws Exception
   {
   }
   
   private void testEncodeDecode(VaultPermissionEntry p)
   {
      DERObject derObject = p.toASN1Object();
      assertTrue( derObject instanceof DERSequence ); 
      DERSequence derSequence = (DERSequence) derObject;
      
      /*
      byte[] encodedBytes = derSequence.getDEREncoded();
      FileOutputStream out = new FileOutputStream("VaultPermissionEntry.testRead.der");
      out.write(encodedBytes);
      */
      VaultPermissionEntry recovered = new VaultPermissionEntry(derSequence);
      
      assertEquals(p, recovered);
   }
   
   @Test
   public void testRead() throws Exception
   {
      VaultPermissionEntry p = new VaultPermissionEntry();
      p.setRead(true);
      
      assertEquals( true, p.canRead() );
      assertEquals( false, p.canWrite() );
      assertEquals( false, p.canList() );
      assertEquals( false, p.canDeleteVault() );
      assertEquals( false, p.canModifyACL() );
      assertEquals( false, p.canRebuild() );
      
      testEncodeDecode(p);
   }
   
   @Test
   public void testWrite() throws Exception
   {
      VaultPermissionEntry p = new VaultPermissionEntry();
      p.setWrite(true);
      
      assertEquals( false, p.canRead() );
      assertEquals( true, p.canWrite() );
      assertEquals( false, p.canList() );
      assertEquals( false, p.canDeleteVault() );
      assertEquals( false, p.canModifyACL() );
      assertEquals( false, p.canRebuild() );
      
      testEncodeDecode(p);
   }
   
   @Test
   public void testList() throws Exception
   {
      VaultPermissionEntry p = new VaultPermissionEntry();
      p.setList(true);
      
      assertEquals( false, p.canRead() );
      assertEquals( false, p.canWrite() );
      assertEquals( true, p.canList() );
      assertEquals( false, p.canDeleteVault() );
      assertEquals( false, p.canModifyACL() );
      assertEquals( false, p.canRebuild() );
      
      testEncodeDecode(p);
   }
   
   @Test
   public void testDeleteVault() throws Exception
   {
      VaultPermissionEntry p = new VaultPermissionEntry();
      p.setDeleteVault(true);
      
      assertEquals( false, p.canRead() );
      assertEquals( false, p.canWrite() );
      assertEquals( false, p.canList() );
      assertEquals( true, p.canDeleteVault() );
      assertEquals( false, p.canModifyACL() );
      assertEquals( false, p.canRebuild() );
      
      testEncodeDecode(p);
   }
   
   @Test
   public void testModifyACL() throws Exception
   {
      VaultPermissionEntry p = new VaultPermissionEntry();
      p.setModifyACL(true);
      
      assertEquals( false, p.canRead() );
      assertEquals( false, p.canWrite() );
      assertEquals( false, p.canList() );
      assertEquals( false, p.canDeleteVault() );
      assertEquals( true, p.canModifyACL() );
      assertEquals( false, p.canRebuild() );
      
      testEncodeDecode(p);
   }
   
   @Test
   public void testRebuild() throws Exception
   {
      VaultPermissionEntry p = new VaultPermissionEntry();
      p.setRebuild(true);
      
      assertEquals( false, p.canRead() );
      assertEquals( false, p.canWrite() );
      assertEquals( false, p.canList() );
      assertEquals( false, p.canDeleteVault() );
      assertEquals( false, p.canModifyACL() );
      assertEquals( true, p.canRebuild() );
      
      testEncodeDecode(p);
   }

}


