//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Jun 29, 2007
//---------------------

package org.cleversafe.vault.storage.asn1;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.cleversafe.vault.storage.asn1.KeyUsage;
import org.cleversafe.vault.storage.asn1.PlainKeyInfo;
import org.cleversafe.vault.storage.asn1.VaultPublicKeys;
import org.cleversafe.vault.storage.asn1.KeyInfo.KeyInfoPair;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;


// TODO: Describe class or interface
public class VaultPublicKeysTest
{
   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
   }

   @AfterClass
   public static void tearDownAfterClass() throws Exception
   {
   }

   @Before
   public void setUp() throws Exception
   {
   }

   @After
   public void tearDown() throws Exception
   {
   }

   @Test
   public void testVaultPublicKeys() throws Exception
   {
      KeyInfoPair pair1 = PlainKeyInfo.generateKeyPair("RSA", 512, KeyUsage.DATASOURCE_VERIFICATION);
      KeyInfoPair pair2 = PlainKeyInfo.generateKeyPair("RSA", 512, KeyUsage.SLICE_VERIFICATION);
      
      VaultPublicKeys publicKeys = new VaultPublicKeys();
      publicKeys.put(1, (PlainKeyInfo)pair1.getPublic());
      publicKeys.put(2, (PlainKeyInfo)pair2.getPublic());
      
      DERObject derObj = publicKeys.toASN1Object();
      
      assertTrue( derObj instanceof ASN1Sequence );
      
      System.out.println( ASN1Dump.dumpAsString(derObj) );
      
      
      VaultPublicKeys recovered = VaultPublicKeys.getInstance(derObj);
      
      System.out.println( ASN1Dump.dumpAsString(recovered) );
      
      assertEquals( publicKeys.get(1), recovered.get(1) );
      assertEquals( publicKeys.get(2), recovered.get(2) );
   }

}


