package org.cleversafe.vault.util;

import java.util.UUID;

import static org.junit.Assert.*;
import org.apache.log4j.Logger;
import org.cleversafe.util.UUIDGen;
import org.junit.BeforeClass;
import org.junit.Test;


/**
 * Class to test the mostly trivial string->UUID converter.
 * 
 * @author Zachary Mark
 * 
 */
public class UUIDGenTest
{
   private static Logger _logger = Logger.getLogger(UUIDGenTest.class);

   private String testUsername = "griduser";
   private String testUUID = "d2577a28-443c-33bf-9c8f-d3cb14961d16";
   
   @BeforeClass
   public static void setUpBeforeClass() throws Exception
   {
   }
   
   @Test
   public void testUUIDGen()
   {
      _logger.debug("Generating UUID");
      UUID generatedUUID = UUIDGen.getUUIDFromUsername(testUsername);
      
      assertEquals("Generated UUID and known UUID are not equal!", generatedUUID.toString(), testUUID);
   }
}
