//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Jul 13, 2007
//---------------------

package org.cleversafe.vault.util;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.util.UUID;

import org.cleversafe.util.UUIDStringParser;
import org.junit.Test;

import com.martiansoftware.jsap.ParseException;

// TODO: Describe class or interface
public class UUIDStringParserTest
{

   @Test
   public void testParseStringValid() throws Exception
   {
      UUID id = UUID.randomUUID();
      UUIDStringParser parser = new UUIDStringParser();
      UUID read = (UUID) parser.parse( id.toString() );
      
      assertEquals("parsed UUID does not match original", id, read);
   }
   
   @Test
   public void testParseStringInvalid()
   {
      try
      {
         UUIDStringParser parser = new UUIDStringParser();
         parser.parse( "bad-valid" );
         fail("exception not thrown by parse for bad UUID");
      }
      catch (ParseException e) {}
      catch (Exception e)
      {
         fail("Bad exception thrown by UUID parser");
      }
   }

}


