package org.jscsi.scsi.protocol.cdb;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

import org.jscsi.scsi.protocol.util.ByteBufferInputStream;

public class Release6 extends AbstractCDB 
{
	public static final int OPERATION_CODE = 0x17;
	
	protected Release6()
	{
		super(OPERATION_CODE);
	}
	public int size() 
	{
		return 6;
	}

	public void decode(byte[] header, ByteBuffer buffer) throws IOException 
	{
		DataInputStream in = new DataInputStream(new ByteBufferInputStream(buffer));
		int tmp;

		int operationCode = in.readUnsignedByte();
		tmp = in.readInt();
		super.setControl(in.readUnsignedByte());

		if (operationCode != OPERATION_CODE)
		{
			throw new IOException("Invalid operation code: " + Integer.toHexString(operationCode));
		}

	}

	public byte[] encode() throws IOException 
	{
		ByteArrayOutputStream cdb = new ByteArrayOutputStream(this.size());
		DataOutputStream out = new DataOutputStream(cdb);

		try
		{
			//0 Operation code (0x16)
			out.writeByte(OPERATION_CODE);
			//1-4 Reserved/obsolete
			out.writeInt(0);
			//5 Control
			out.writeByte(super.getControl());

			return cdb.toByteArray();
		}
		catch (IOException e)
		{
			throw new RuntimeException("Unable to encode CDB.");
		}
	}

}
