
package org.jscsi.scsi.protocol.inquiry.vpd;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;

import org.jscsi.core.exceptions.NotImplementedException;

public class UnitSerialNumberVPD extends VPDPage
{

   public static final int PAGE_CODE = 0x80;

   private String productSerialNumber;

   public UnitSerialNumberVPD(
         int peripheralQualifier,
         int peripheralDeviceType,
         String productSerialNumber)
   {
      this.setPageCode(PAGE_CODE);
      this.setPeripheralQualifier(peripheralQualifier);
      this.setPeripheralDeviceType(peripheralDeviceType);

      // Note: Serial number should be padded by 4
      // Consider using vault serial number as productSerialNumber
      this.productSerialNumber = productSerialNumber;
      if (productSerialNumber == null)
      {
         this.productSerialNumber = (UUID.randomUUID()).toString();
      }
   }

   /**
    * The product serial number field contains right-aligned ASCII data that is a vendor-assigned
    * serial number.  If the product serial number is not available, the device server shall return
    * ASCII spaces (20h) in this field.
    * 
    * @param peripheralQualifier
    * @param peripheralDeviceType
    */
   public UnitSerialNumberVPD(int peripheralQualifier, int peripheralDeviceType)
   {
      this(peripheralQualifier, peripheralDeviceType, null);
   }

   public void decode(byte[] header, ByteBuffer buffer) throws IOException
   {
      throw new NotImplementedException("Decoding not implemented at this time.");
   }

   public byte[] encode() throws IOException
   {
      int pageSize = this.productSerialNumber.length();
      ByteArrayOutputStream baos = new ByteArrayOutputStream(pageSize);
      DataOutputStream out = new DataOutputStream(baos);

      try
      {
         // byte 0
         out.writeByte((this.getPeripheralQualifier() << 5) | this.getPeripheralDeviceType());

         // byte 1
         out.writeByte(this.getPageCode());

         // byte 2
         out.writeByte(0);

         // byte 3
         out.writeByte(pageSize);

         out.write(this.productSerialNumber.getBytes());

         return baos.toByteArray();
      }
      catch (IOException e)
      {
         throw new RuntimeException("Unable to encode CDB.");
      }
   }
}
