package org.jscsi.scsi.protocol.inquiry.vpd.deviceidentification;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class T10DeviceIdentifier extends VendorSpecificIdentifier 
{
	// This is a constant defined in Table 300 (sec 7.6.3.2.4) of SPC-3.
	// A T10 vendor ID is exactly 8 bytes.
	public static final int T10_VENDOR_ID_LEN = 8;
	
	private byte[] t10VendorID = new byte[T10_VENDOR_ID_LEN];
	
	public T10DeviceIdentifier(byte[] vendorID, byte[] identifier)
	{
		super(identifier);
		assert(vendorID.length == T10_VENDOR_ID_LEN);
		this.t10VendorID = vendorID;
	}
	
	public byte[] getT10VendorID() 
	{
		return this.t10VendorID.clone();
	}

	public void setT10VendorID(byte[] vendorID) 
	{
		assert(vendorID.length == T10_VENDOR_ID_LEN);
		this.t10VendorID = vendorID;
	}

	@Override
	public byte[] encode() throws IOException
	{
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		baos.write(this.t10VendorID);
		baos.write(super.encode());
		return baos.toByteArray();
	}
	
	@Override
	public void decode(byte[] header, ByteBuffer buffer) throws IOException
	{
		this.t10VendorID = new byte[T10_VENDOR_ID_LEN];
		buffer.get(t10VendorID, 0, T10_VENDOR_ID_LEN);
		super.decode(header, buffer);
	}
	
	@Override
	public IdentifierType getType()
	{
		return IdentifierType.T10_VENDOR_ID_BASED;
	}
}
