//Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
//Cleversafe Dispersed Storage(TM) is software for secure, private and
//reliable storage of the world's data using information dispersal.
//
//Copyright (C) 2005-2007 Cleversafe, Inc.
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
//USA.
//
//Contact Information: 
// Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email: licensing@cleversafe.org
//
//END-OF-HEADER
//-----------------------
//@author: John Quigley <jquigley@cleversafe.com>
//@date: January 1, 2008
//---------------------

package org.jscsi.scsi.protocol.sense.exceptions;

import org.jscsi.scsi.protocol.sense.KCQ;
import org.jscsi.scsi.protocol.sense.additional.ProgressIndication;
import org.jscsi.scsi.protocol.sense.additional.SenseKeySpecificField;

/**
 * Sense exception for target in a not ready state due to communication failure
 */
public class NotReadyException extends SenseException
{
   private static final long serialVersionUID = -2867780150665919079L;
   
   // Percent ready (0.0-1.0)
   private float progress;

   public NotReadyException(boolean current)
   {
      this(current, (float) 0.0);
   }

   public NotReadyException(boolean current, float progress)
   {
      super(KCQ.LOGICAL_UNIT_NOT_ACCESSIBLE, current);
      this.progress = progress;
   }

   public void setProgress(float progress)
   {
      this.progress = progress;
   }

   @Override
   protected byte[] getCommandSpecificInformation()
   {
      return null;
   }

   @Override
   protected byte[] getInformation()
   {
      // TODO Auto-generated method stub
      return null;
   }

   @Override
   protected SenseKeySpecificField getSenseKeySpecific()
   {
      return new ProgressIndication((int)(this.progress * 0xffff));
   }
}
