//Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
//Cleversafe Dispersed Storage(TM) is software for secure, private and
//reliable storage of the world's data using information dispersal.
//
//Copyright (C) 2005-2007 Cleversafe, Inc.
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
//USA.
//
//Contact Information: 
// Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email: licensing@cleversafe.org
//
//END-OF-HEADER
//-----------------------
//@author: John Quigley <jquigley@cleversafe.com>
//@date: January 1, 2008
//---------------------

package org.jscsi.scsi.tasks;

import org.jscsi.scsi.protocol.Command;
import org.jscsi.scsi.transport.TargetTransportPort;

public interface Task extends Runnable
{
   
   public enum TaskStatus
   {
      COMPLETED,
      ABORTED,
      IN_PROGRESS
      ;
   }
   
   
   /**
    * Begins execution of the task.
    * <p>
    * In production code this method is only called once. However, implementations should allow
    * multiple calls to ease testing implementations.
    * <p>
    * If {@link #abort()} was called beforehand this method must return immediately without
    * performing any actions. It must not write any response data to the target transport port.
    */
   public void run();

   /**
    * Attempts to abort the current task. When successful the thread running the task is
    * interrupted, outstanding data transfers are canceled, and any response data is discarded.
    * <p>
    * An abort attempt will generally fail if the task has already been completed and is in the
    * process of writing a response to the target transport port.
    * <p>
    * The task thread is not guaranteed to be ready to join immediately after this method returns.
    * <p>
    * This method must return <code>true</code> if the task has not yet started. When
    * <code>true</code> is returned this task must not write response data to the target
    * transport port and should not begin execution if {@link #run()} is called.
    * 
    * @return True if the abort attempt was successful; False if the task is complete or is in
    *    the process of writing the response data to the target transport port.
    */
   public boolean abort();

   
   /**
    * Wait for the task to complete or be aborted.
    */
   public TaskStatus waitForFinish();
   
   
   /**
    * Returns the command which this task executes.
    */
   public Command getCommand();
   
   /**
    * Returns the current status of the task.
    */
   public TaskStatus getStatus();
  
   
   /**
    * Returns the target transport port which issued the command this task executes. The task
    * uses this transport port to transfer data and write response data to.
    */
   public TargetTransportPort getTargetTransportPort();
}
