//Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
//Cleversafe Dispersed Storage(TM) is software for secure, private and
//reliable storage of the world's data using information dispersal.
//
//Copyright (C) 2005-2007 Cleversafe, Inc.
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
//USA.
//
//Contact Information: 
// Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email: licensing@cleversafe.org
//
//END-OF-HEADER
//-----------------------
//@author: John Quigley <jquigley@cleversafe.com>
//@date: January 1, 2008
//---------------------

package org.jscsi.scsi.tasks.buffered;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

import org.jscsi.scsi.tasks.Status;
import org.jscsi.scsi.protocol.cdb.ReadCapacity10;
import org.jscsi.scsi.protocol.cdb.ReadCapacity16;
import org.jscsi.scsi.protocol.sense.exceptions.SenseException;

//TODO: Describe class or interface
public class BufferedReadCapacityTask extends BufferedTask
{

   public BufferedReadCapacityTask()
   {
      super("BufferedReadCapacityTask");
   }

   @Override
   protected void execute(ByteBuffer file, int blockLength) throws InterruptedException,
         SenseException
   {
      // NOTE: We ignore the PMI bit because file has no substantial transfer delay point
      ByteArrayOutputStream bs = new ByteArrayOutputStream();
      DataOutputStream out = new DataOutputStream(bs);

      try
      {
         if (getCommand().getCommandDescriptorBlock() instanceof ReadCapacity10)
         {
            if (this.getDeviceCapacity() >= 0xFFFFFFFFL)
            {
               out.writeInt(-1);
            }
            else
            {
               out.writeInt((int) this.getDeviceCapacity());
            }
            out.writeInt(blockLength);
         }
         else if (getCommand().getCommandDescriptorBlock() instanceof ReadCapacity16)
         {
            out.writeLong(this.getDeviceCapacity());
            out.writeInt(blockLength);

            out.writeInt(0);
            out.writeLong(0);
            out.writeLong(0);
         }
         else
         {
            throw new RuntimeException("Invalid CDB passed in ReadCapacityGridTask");
         }
      }
      catch (IOException e)
      {
         throw new RuntimeException("unable to encode READ CAPACITY parameter data");
      }

      this.writeData(ByteBuffer.wrap(bs.toByteArray()));
      this.writeResponse(Status.GOOD, null);
   }
}
