package org.jscsi.scsi.tasks.lu;

import java.nio.ByteBuffer;

import org.apache.log4j.Logger;
import org.jscsi.scsi.tasks.Status;
import org.jscsi.scsi.protocol.Command;
import org.jscsi.scsi.protocol.cdb.AbstractParameterCDB;
import org.jscsi.scsi.protocol.inquiry.InquiryDataRegistry;
import org.jscsi.scsi.protocol.mode.ModePageRegistry;
import org.jscsi.scsi.protocol.sense.exceptions.SenseException;
import org.jscsi.scsi.transport.TargetTransportPort;

public class ModeSelectTask extends LUTask 
{
	private static Logger _logger = Logger.getLogger(ModeSelectTask.class);
	/**
	 * Creates a new WriteGridTask.
	 */
	public ModeSelectTask()
	{
		super("ModeSelectTask");
	}

	/**
	 * Creates a new WriteGridTask.
	 * 
	 * @param targetPort
	 * @param command
	 * @param modePageRegistry
	 * @param inquiryDataRegistry
	 * @param device
	 */
	public ModeSelectTask(
			TargetTransportPort targetPort,
			Command command,
			ModePageRegistry modePageRegistry,
			InquiryDataRegistry inquiryDataRegistry)
	{
		super("ModeSelectTask", targetPort, command, modePageRegistry, inquiryDataRegistry);
	}

	@Override
	protected void execute() throws InterruptedException, SenseException 
	{
		AbstractParameterCDB modeSelectCDB = (AbstractParameterCDB) this.getCommand().getCommandDescriptorBlock();
		
		// Normally I wouldn't advocate a cast like this, but when is the initiator ever going to 
		// send a parameter list larger than Integer.MAX_VALUE bytes?
		ByteBuffer buf = ByteBuffer.allocate((int) modeSelectCDB.getParameterLength());
		
		//_logger.warn(modeSelectCDB.getParameterLength());
		//this.readData(buf);
		
		this.writeResponse(Status.GOOD, null);
	}

}
