#!/bin/sh

if [ "${DEVELOPMENT}" != "false" ]; then
   echo "Setting up development environment"
   export DEVELOPMENT="true"
fi

pwdir() {
   (mkdir -p $1; cd $1; echo `pwd`)
}

DEV_LOGGER="`pwdir ../conf`/log4j-local.xml"
RPM_LOGGER="`pwdir ../conf`/log4j.xml"
CLI_LOGGER="`pwdir ../conf`/log4j-cli.xml"
DEV_OUTPUT="`pwdir ../output/accesser/directory`"
RPM_OUTPUT="/data/accesser/directory"
DIRS=".. ../lib"

#echo DEBUG: DEV_LOGGER=${DEV_LOGGER}
#echo DEBUG: RPM_LOGGER=${RPM_LOGGER}

process() {
   TYPE="${1}"
   INPUT="../setup/${2}.in"
   OUTPUT="../bin/${2}"
   
   #echo INPUT:${INPUT}
   #echo OUTPUT:${OUTPUT}
   #echo LOGGER:${LOGGER}
   #echo DIRS:${DIRS}
   java -cp ../lib/dsnet-core.jar org.cleversafe.util.ClasspathStringGenerator ${INPUT} ${OUTPUT} ${DIRS}
   if [ "${DEVELOPMENT}" == "true" ]; then
      sed -i "s;@LOGGER@;${DEV_LOGGER};" ${OUTPUT}
   elif [ "${TYPE}" == "cli" ]; then
      sed -i "s;@LOGGER@;${CLI_LOGGER};" ${OUTPUT}
   else
      sed -i "s;@LOGGER@;${RPM_LOGGER};" ${OUTPUT}
   fi
   if [ "${DEVELOPMENT}" == "true" ]; then
      sed -i "s;@OUTPUT@;${DEV_OUTPUT};" ${OUTPUT}
   else
      sed -i "s;@OUTPUT@;${RPM_OUTPUT};" ${OUTPUT}
   fi
   chmod a+x ${OUTPUT}
}


if [ "${DEVELOPMENT}" == "true" ]; then
   java -cp ../lib/dsnet-core.jar org.cleversafe.util.WrapperScriptGenerator ../setup/wrapper-accesser-dev.conf.in ../conf/wrapper-accesser.conf .. ../lib
   sed -i "s;@LOGGER@;${DEV_LOGGER};" ../conf/wrapper-accesser.conf
else
   java -cp ../lib/dsnet-core.jar org.cleversafe.util.WrapperScriptGenerator ../setup/wrapper-accesser.conf.in ../conf/wrapper-accesser.conf .. ../lib
   sed -i "s;@LOGGER@;${RPM_LOGGER};" ../conf/wrapper-accesser.conf   
fi

chmod a+x ../bin/wrapper

process cli dsnet-create-vault
process cli dsnet-delete-vault
process cli dsnet-list-vaults
process cli dsnet-create-target
process cli dsnet-delete-target
process cli dsnet-list-targets
process cli dsnet-change-portal
process cli dsnet-perf-calc
process init accesser

if [ "${DEVELOPMENT}" == "true" ]; then
   sed -i "s;@RUN_AS_USER@;#RUN_AS_USER;" ../bin/accesser
else
   sed -i "s;@RUN_AS_USER@;RUN_AS_USER;" ../bin/accesser
fi


process cli populate-defaults.sh
sh ../bin/populate-defaults.sh
