//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: vthornton
//
// Date: Sep 26, 2007
//---------------------

package org.cleversafe.storage.ss.handlers.slice;

import org.cleversafe.layer.protocol.IntegrityVerificationRequest;
import org.cleversafe.layer.protocol.IntegrityVerificationResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.layer.protocol.exceptions.ProtocolLayerException;
import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreLayerException;
import org.cleversafe.server.exceptions.ServerException;
import org.cleversafe.vault.exceptions.VaultException;

public class IntegrityVerificationHandler extends SliceStoreOperationHandler
{
   @Override
   protected Response performOperation(Request request, SliceStore sliceStore)
         throws ProtocolLayerException, SliceStoreLayerException, ServerException, VaultException
   {
      IntegrityVerificationRequest verificationRequest = (IntegrityVerificationRequest) request;

      return new IntegrityVerificationResponse(
            sliceStore.verifyIntegrity(verificationRequest.getSlices()));
   }

   public Class<IntegrityVerificationRequest> getRequestClass()
   {
      return IntegrityVerificationRequest.class;
   }

}
