package org.cleversafe.storage.ss.handlers.sessions;

// TODO: cleanup unused imports
import static org.junit.Assert.fail;

import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

import org.apache.log4j.BasicConfigurator;
import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.server.ClientSession;
import org.cleversafe.storage.ss.SliceServerApplication;
import org.cleversafe.storage.ss.handlers.SliceStorePerformanceBase;
import org.cleversafe.storage.ss.handlers.slices.PerformanceResults;
import org.cleversafe.util.BoundedThreadPoolExecutor;
import org.junit.BeforeClass;
import org.junit.Test;



public class BeginSessionHandlerPerformanceTest extends SliceStorePerformanceBase
{			
	@Test
	public void beginSessionHandlerPerformance_n()
	{
		// Work item that is run in a thread.
		class WriteWorkItem implements Runnable
		{
			int id;
			SliceStore ss;
			
			public WriteWorkItem(int opid, SliceStore ss)
			{
				this.id = opid;
				this.ss = ss;
			}
		
			public void run()
			{
				BeginSessionHandlerPerformanceTest test = BeginSessionHandlerPerformanceTest.this;;
				try
				{
				   synchronized(ss)
				   {
				      ss.startSession();
				      ss.endSession();
				   }
	        	 }
				catch (Exception ex)
				{
	        		 ex.printStackTrace();
	        		 fail("Start session failed");
	        	 }
	      }
	   }
	
		ExecutorService executor = new BoundedThreadPoolExecutor("BeginSessionHandler", numConcurrentRequests);
		
		// Start Operations.
		int operations;
		long beginTest, endTest;
		
		ClientSession cs = null;
      try
      {
         cs = createSession();
      }
      catch (Exception e1)
      {
         fail("Unable to create session");
      }
      SliceStore ss = (SliceStore) cs.get(cs.SLICE_STORE);
		
		beginTest = System.currentTimeMillis();
		
		for (operations = 1; operations < testIterations; operations++)
		{
			// execute rollback in a thread.
			executor.execute( new WriteWorkItem(operations, ss) );
		}
		      
		executor.shutdown();
		System.out.println("Waiting for threads to stop.");
		boolean finished = false;
		do
		{
			try
			{
				finished = executor.awaitTermination( 10, TimeUnit.SECONDS );
			} catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		} while ( !finished );
	
		endTest = System.currentTimeMillis();
	
		PerformanceResults results =  new PerformanceResults("BeginSessionHandler", testIterations, 0, beginTest, endTest, numConcurrentRequests);
		results.print(true);

	}
	
}
