package org.cleversafe.storage.ss.handlers.slices;

import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

import org.cleversafe.layer.grid.DataSlice;
import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.layer.protocol.BeginTransactionRequest;
import org.cleversafe.layer.protocol.BeginTransactionResponse;
import org.cleversafe.layer.protocol.CommitTransactionRequest;
import org.cleversafe.layer.protocol.CommitTransactionResponse;
import org.cleversafe.layer.protocol.MultipleReadRequest;
import org.cleversafe.layer.protocol.MultipleReadResponse;
import org.cleversafe.layer.protocol.MultipleWriteRequest;
import org.cleversafe.layer.protocol.MultipleWriteResponse;
import org.cleversafe.storage.ss.handlers.SliceStorePerformanceBase;
import org.cleversafe.util.BoundedThreadPoolExecutor;
import org.junit.Test;

public class MultipleReadHandlerPerformanceTest extends SliceStorePerformanceBase
{

	public static HashMap<Integer, SliceName[]> multiSliceNames = null;

	
	@Test
	public void multipleReadHandlerPerformance_n()
	{
	
		class WorkItem implements Runnable
		{
			public WorkItem(int id)
			{
				sliceNames = multiSliceNames.get(id);
			}
			public void run()
			{
				MultipleReadHandlerPerformanceTest test = MultipleReadHandlerPerformanceTest.this;;
				try {
					// Create Request
					 
					MultipleReadResponse response = (MultipleReadResponse) test.sliceServer
					.service(new MultipleReadRequest(sliceNames), session);
					
					if (response.getExceptionFlag()) 
					{
						response.getException().printStackTrace();
					}
					// Ensure no exception flag was set
					assertTrue("An exception was thrown by the SliceServer",
							response.getExceptionFlag() == false);
	        	 } catch (ClassCastException ex) {
	        		 ex.printStackTrace();
	        		 fail("SliceServer returned an inproper Response type");
	        	 }
	         }
	      }
	
	
		ExecutorService executor = new BoundedThreadPoolExecutor("MultiRead Handler", numConcurrentRequests);
		try {
			// Create a session with a valid SliceStore
			session = createSession();
		} catch (Exception ex) {
			ex.printStackTrace();
			fail("Unable to start an operational slice store");
		}
		
		writeSlices();
	;
		long beginTest, endTest;
		
		// create multiple data slices used for MultipleReadWrite operations.
		// the map multiDataSlice contains map of <firstslice> -> DataqSlices[] array of numRequestinOper size.
		multiSliceNames = new HashMap<Integer, SliceName[]>();
		int operations;
		for (operations = 1; operations < testIterations; operations += numRequestsInOper)
		{
			SliceName ds[] = new SliceName[numRequestsInOper];
			for (int i=0; i < MultipleWriteHandlerPerformanceTest.numRequestsInOper; i++)
			{
				ds[i] =	new SliceName(Integer.toString(operations + i), 0);
			}
			multiSliceNames.put(operations, ds);
		}
		try {
			// Create Transaction
			BeginTransactionResponse beginTransactionResponse = (BeginTransactionResponse) this.sliceServer
					.service(new BeginTransactionRequest(txnID), session);
			// Ensure no exception flag was set
			assertTrue("An exception was thrown by the SliceServer",
					beginTransactionResponse.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}
		
		// Start Operations.
		beginTest = System.currentTimeMillis();
		
		for (operations = 1; operations < testIterations; operations += numRequestsInOper) {
			// execute in an available thread.
			executor.execute( new WorkItem(operations) );
			//(new WorkItem(operations)).run();
		}
		      
		executor.shutdown();
		System.out.println("Waiting for threads to stop.");
		boolean finished = false;
		do
		{
			try
			{
				finished = executor.awaitTermination( 10, TimeUnit.SECONDS );
			} catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		} while ( !finished );
	
		// Commit Transaction.
		endTest = System.currentTimeMillis();
		
		try {
			// Commit Transaction
			CommitTransactionResponse commitTransactionResponse = (CommitTransactionResponse) this.sliceServer
					.service(new CommitTransactionRequest(txnID), session);
			// Ensure no exception flag was set
			assertTrue("An exception was thrown by the SliceServer",
					commitTransactionResponse.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}
		
		PerformanceResults results =  new PerformanceResults("MultiReadHandler", testIterations, requestSize, beginTest, endTest);
		results.setNumRequestsInOper(numRequestsInOper);
		results.print(true);

	}
	
	/*
	 * Write slices so that we can read them.
	 */
	
	private void writeSlices()
	{
		// start a transaction.
		try {
			// Create Transaction
			BeginTransactionResponse beginTransactionResponse = (BeginTransactionResponse) this.sliceServer
					.service(new BeginTransactionRequest(txnID), session);
			// Ensure no exception flag was set
			assertTrue("An exception was thrown by the SliceServer",
					beginTransactionResponse.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}
	
		// write individual slices. No need to do in threads, or Multiple writes.
		int i;
		for (i = 1; i < testIterations; i++) {
			try {
				// Create Request and service it.
			   MultipleWriteResponse response = (MultipleWriteResponse) sliceServer
				.service(new MultipleWriteRequest( new DataSlice(new SliceName(Integer.toString(i), 0), txnID, data)), session);
				
				// Ensure no exception flag was set
				assertTrue("An exception was thrown by the SliceServer",
						response.getExceptionFlag() == false);
        	 } catch (ClassCastException ex) {
        		 fail("SliceServer returned an inproper Response type");
        	 }
		}
		
		// end the transaction.
		try {
			// Commit Transaction
			CommitTransactionResponse commitTransactionResponse = (CommitTransactionResponse) this.sliceServer
					.service(new CommitTransactionRequest(txnID), session);
			// Ensure no exception flag was set
			assertTrue("An exception was thrown by the SliceServer",
					commitTransactionResponse.getExceptionFlag() == false);
		} catch (ClassCastException ex) {
			fail("SliceServer returned an inproper Response type");
		}
	}
}

