package org.cleversafe.storage.ss.handlers.transactions;


import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

import org.apache.log4j.BasicConfigurator;
import org.cleversafe.layer.protocol.BeginTransactionRequest;
import org.cleversafe.layer.protocol.BeginTransactionResponse;
import org.cleversafe.server.ClientSession;
import org.cleversafe.storage.ss.SliceServerApplication;
import org.cleversafe.storage.ss.handlers.SliceStorePerformanceBase;
import org.cleversafe.storage.ss.handlers.slices.PerformanceResults;
import org.cleversafe.util.BoundedThreadPoolExecutor;
import org.junit.BeforeClass;
import org.junit.Test;


                                                            
public class BeginTransactionHandlerPerformanceTest extends SliceStorePerformanceBase
{

	// How long test should be run. This is mutually exclusive with testIterations
	// Only one of them is used.
	private static int testDuration;
	// I/O Request Size in KB
	private static int requestSize;
	// Number of concurrent requests
	private static int numConcurrentRequests;

	// how many operations to be performed. This is mutually exclusive with testDuration.
	// Only one of them is used.
	private static int testIterations;

	private static UUID accountUUID;
	private SliceServerApplication sliceServer = null;

	private static ClientSession sessions[];

	public  byte[] data;
	
	@BeforeClass
	public static void initializeTests()
	{
		

		// Only one of testIterations or testDuration is used.
		testIterations = Integer.getInteger("test.operations", 1000); //
		testDuration = Integer.getInteger("test.duration", 1); // 1 minutes
		numConcurrentRequests = Integer.getInteger("test.concurrency", 7); //
		requestSize = Integer.getInteger("test.requestsize", 4); // 4K

		// Setup basic logging
		BasicConfigurator.configure();
		// Create data once and write the same stuff over and over again.

	}
	
		
	@Test
	public void beginTransactionHandlerPerformance_n()
	{
	
		data = new byte[requestSize * 1024];
		randomizeBuffer(data);
		
		class WorkItem implements Runnable
		{
			int sessionIdx;
			public WorkItem(int sess)
			{
				sessionIdx = sess;
			}
			public void run()
			{
				BeginTransactionHandlerPerformanceTest test = BeginTransactionHandlerPerformanceTest.this;
					// End a specific session
					
				try {
					// Create Transaction, use sessionIdx as Txn id.
					BeginTransactionResponse beginTransactionResponse = (BeginTransactionResponse)
						test.sliceServer
							.service(new BeginTransactionRequest(sessionIdx),  sessions[sessionIdx]);
					// Ensure no exception flag was set
					assertTrue("An exception was thrown by the SliceServer",
							beginTransactionResponse.getExceptionFlag() == false);
				} catch (ClassCastException ex) {
					fail("SliceServer returned an inproper Response type");
				}
	         }
	      }
	
		sessions = new ClientSession[testIterations];
		// create an array of sessions.
		int operations;
		for (operations = 1; operations < testIterations; operations++) {
			try
			{
				sessions[operations] = createSession();
			} catch (Exception ex) {
				ex.printStackTrace();
				fail("Error creating session " + operations);
			}
		}
		
		ExecutorService executor = new BoundedThreadPoolExecutor("Begin Transaction Handler Test", numConcurrentRequests);
	
		// Start Operations.

		long beginTest, endTest;
		beginTest = System.currentTimeMillis();
		
		for (operations = 1; operations < testIterations; operations++) {
		 
			executor.execute( new WorkItem(operations) );
		}
		      
		executor.shutdown();
		System.out.println("Waiting for threads to stop.");
		boolean finished = false;
		do
		{
			try
			{
				finished = executor.awaitTermination( 10, TimeUnit.SECONDS );
			} catch (InterruptedException e)
			{
				e.printStackTrace();
			}
		} while ( !finished );
		
		endTest = System.currentTimeMillis();
//		System.out.println(testIterations + "|" + beginTest + "|" + endTest + "|" + numConcurrentRequests);
		PerformanceResults results =  new PerformanceResults("BeginTransaction", testIterations, 0, beginTest, endTest, numConcurrentRequests);
		results.print(true);

	}
	

}

