//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: dhendrickson
//
// Date: Nov 19, 2007
//---------------------

package org.cleversafe.storage.ss;

import static org.junit.Assert.assertEquals;

import java.util.Map;

import org.cleversafe.authentication.AuthenticationFacilitatorConfiguration;
import org.cleversafe.authentication.JAASConfiguration;
import org.cleversafe.layer.communication.Acceptor;
import org.cleversafe.layer.communication.network.mina.MinaAcceptor;
import org.cleversafe.layer.slicestore.SliceStoreDescriptorManager;
import org.cleversafe.layer.slicestore.SliceStoreManager;
import org.cleversafe.layer.slicestore.block.BlockFileSliceStoreManager;
import org.cleversafe.serialization.ProtocolMessageFactory;
import org.cleversafe.serialization.raw.RawGridProtocolMessageFactory;
import org.cleversafe.test.BaseTest;
import org.junit.Test;

public class SliceServerConfigurationTest extends BaseTest
{
   @Test
   public void testAcceptor()
   {
      SliceServerConfiguration config = new SliceServerConfiguration();
      
      Acceptor acceptor = new MinaAcceptor();
      config.setAcceptor(acceptor);
      Acceptor testAcceptor = config.getAcceptor();
      
      assertEquals(acceptor, testAcceptor);
   }
   
   @Test
   public void testProtocolMessageFactory()
   {
      SliceServerConfiguration config = new SliceServerConfiguration();
      
      ProtocolMessageFactory protocolMessageFactory = new RawGridProtocolMessageFactory();
      config.setProtocolMessageFactory(protocolMessageFactory);
      ProtocolMessageFactory testProtocolMessageFactory = config.getProtocolMessageFactory();
      
      assertEquals(protocolMessageFactory, testProtocolMessageFactory);
   }
   
   @Test
   public void testJAASConfiguration()
   {
      SliceServerConfiguration config = new SliceServerConfiguration();
      
      AuthenticationFacilitatorConfiguration authConfig = new JAASConfiguration();
      config.setAuthenticationFacilitatorConfiguration(authConfig);
      AuthenticationFacilitatorConfiguration testAuthConfig = config.getAuthenticationFacilitatorConfiguration();
      
      assertEquals(authConfig, testAuthConfig);
   }
   
   @Test
   public void testSliceStoreDescriptorManager()
   {
      SliceServerConfiguration config = new SliceServerConfiguration();
      
      SliceStoreDescriptorManager descriptor = new SliceStoreDescriptorManager();
      config.setSliceStoreDescriptorManager(descriptor);
      SliceStoreDescriptorManager testDescriptor = config.getSliceStoreDescriptorManager();
      
      assertEquals(descriptor, testDescriptor);
   }
   
   @Test
   public void testVaultTypes()
   {
      SliceServerConfiguration config = new SliceServerConfiguration();
      
      SliceStoreManager manager1 = new BlockFileSliceStoreManager();
      config.addSliceStoreManager("type1", manager1);
      
      SliceStoreManager manager2 = new BlockFileSliceStoreManager();
      config.addSliceStoreManager("type2", manager2);
      
      SliceStoreManager testManager1 = config.getDefaultSliceStoreManager("type1");
      assertEquals(manager1, testManager1);
      
      SliceStoreManager testManager2 = config.getDefaultSliceStoreManager("type2");
      assertEquals(manager2, testManager2);
      
      String[] vaultTypes = config.getVaultTypes();
      assertEquals(vaultTypes[0], "type1");
      assertEquals(vaultTypes[1], "type2");
      
      Map<String,SliceStoreManager> vaultManagerMap = config.getVaultSliceStoreManagerMap();
      assertEquals(2, vaultManagerMap.size());
      assertEquals(manager1, vaultManagerMap.get("type1"));
      assertEquals(manager2, vaultManagerMap.get("type2"));
   }
}


