
package org.cleversafe.storage.ss.handlers.slices;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.cleversafe.layer.protocol.ListBeginRequest;
import org.cleversafe.layer.protocol.ListBeginResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.layer.protocol.exceptions.ProtocolLayerException;
import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreLayerException;
import org.cleversafe.server.ClientSession;
import org.cleversafe.server.exceptions.IllegalSessionStateException;
import org.cleversafe.server.exceptions.ServerException;
import org.cleversafe.server.exceptions.UnauthorizedRequestException;
import org.cleversafe.storage.ss.handlers.HandlerTestBase;
import org.cleversafe.vault.exceptions.VaultException;
import org.junit.Test;

public class ListBeginHandlerTest extends HandlerTestBase
{
   @Test(expected = IllegalSessionStateException.class)
   public final void testRequiresSliceStore() throws ProtocolLayerException,
         SliceStoreLayerException, ServerException, VaultException
   {
      checkRequiresSliceStore();
   }

   @Test(expected = UnauthorizedRequestException.class)
   public final void testRequiresListPermission() throws Exception
   {
      checkRequiresPermission();
   }

   @Test
   public final void testService() throws Exception
   {
      ClientSession session = createClientSession();
      authenticateSession(session);
      addSliceStore(session);
      addListPermission(session);

      SliceStore sliceStore = getSliceStore(session);

      sliceStore.startSession();

      writeSlices(sliceStore, createDataSlices(generateSliceNames(0, 25)));

      Response response = this.handler.service(createRequest(), session);

      assertTrue(sliceStore.listInProgress());
      sliceStore.listStop();
      assertFalse(sliceStore.listInProgress());

      sliceStore.endSession();

      assertFalse(response.getExceptionFlag());

      assertTrue(response instanceof ListBeginResponse);
   }

   @Override
   protected Request createRequest()
   {
      return new ListBeginRequest();
   }

}
