package org.cleversafe.storage.ss.handlers.slices;

import static org.junit.Assert.assertEquals;

import java.util.List;

import org.cleversafe.layer.grid.DataSlice;
import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.layer.protocol.MultipleReadResponse;
import org.cleversafe.layer.protocol.MultipleRemoveRequest;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.layer.protocol.exceptions.ProtocolLayerException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreExistsException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreIOException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreLayerException;
import org.cleversafe.server.ClientSession;
import org.cleversafe.server.exceptions.IllegalSessionStateException;
import org.cleversafe.server.exceptions.ServerException;
import org.cleversafe.server.exceptions.UnauthorizedRequestException;
import org.cleversafe.storage.ss.handlers.HandlerTestBase;
import org.cleversafe.vault.exceptions.VaultException;
import org.junit.Test;

public class MultipleRemoveHandlerTest extends HandlerTestBase
{

   public static int offset = 0;
   public static int count = 10;

   // Creates a request to be used by the handler
   @Override
   protected Request createRequest()
   {
      List<SliceName> sliceNames = generateSliceNames(offset, count);

      return new MultipleRemoveRequest(sliceNames);
   }
   
   @Test(expected = IllegalSessionStateException.class)
   public final void testRequiresSliceStore() throws ProtocolLayerException,
         SliceStoreLayerException, ServerException, VaultException
   {
      checkRequiresSliceStore();
   }

   @Test(expected = UnauthorizedRequestException.class)
   public final void testRequiresWritePermission() throws SliceStoreExistsException,
         SliceStoreIOException, Exception
   {
      checkRequiresPermission();
   }


   @Test
   public final void testService() throws Exception
   {
      ClientSession session = this.createClientSession();
      session = this.authenticateSession(session);
      session = this.addSliceStore(session);
      session = this.addWritePermission(session);
      
      // Begin session on slice store
      this.getSliceStore(session).startSession();
      
      // Write Slices to Slice Store
      List<SliceName> sliceNames = this.generateSliceNames(offset, count);
      List<DataSlice> dataSlices = this.createDataSlices(sliceNames);
      this.writeSlices(this.getSliceStore(session), dataSlices);
      
      // Verify slices exist      
      assertEquals(true, slicesExist(getSliceStore(session), sliceNames));
      
      // Remove the Slices
      Response response = this.handler.service(createRequest(), session);
      
      assertEquals(false, response.getExceptionFlag());
      
      // Verify slices are removed    
      assertEquals(true, slicesDontExist(getSliceStore(session), sliceNames));
      
      // End session on slice store
      getSliceStore(session).endSession();
   }
}
