package org.cleversafe.storage.ss.handlers.store;

import static org.junit.Assert.assertEquals;

import java.io.IOException;
import java.util.List;
import java.util.UUID;

import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.layer.protocol.BeginSessionRequest;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.layer.protocol.exceptions.ProtocolLayerException;
import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.layer.slicestore.SliceStoreTransaction;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreExistsException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreIOException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreLayerException;
import org.cleversafe.server.ClientSession;
import org.cleversafe.server.exceptions.IllegalSessionStateException;
import org.cleversafe.server.exceptions.ServerException;
import org.cleversafe.server.exceptions.UnauthorizedRequestException;
import org.cleversafe.storage.ss.handlers.HandlerTestBase;
import org.cleversafe.vault.exceptions.VaultException;
import org.junit.Test;

public class CreateStoreHandlerTest extends HandlerTestBase
{
   UUID vaultId = UUID.randomUUID();
   
   // Creates a request to be used by the handler
   @Override
   protected Request createRequest()
   {
      try
      {
         return this.makeCreateStoreRequest(vaultId);
      }
      catch (Exception e)
      {
         e.printStackTrace();
         return null;
      }
   }

   @Test
   public final void testService() throws Exception
   {
      ClientSession session = createClientSession();
      session = authenticateSession(session);


      // Create the Store
      Response response = this.handler.service(createRequest(), session);

      assertEquals(false, response.getExceptionFlag());

      // Verify we can create and use the store object      
      this.bindVault(session, vaultId);
      Request request = new BeginSessionRequest();
      response = this.sliceServerApp.service(request, session);
      assertEquals(false, response.getExceptionFlag());
      
      // End session on slice store
      getSliceStore(session).endSession();
   }

}
