package org.cleversafe.storage.ss.handlers.transactions;

import static org.junit.Assert.assertEquals;

import org.cleversafe.layer.protocol.BeginTransactionRequest;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.layer.protocol.exceptions.ProtocolLayerException;
import org.cleversafe.layer.slicestore.SliceStoreTransaction;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreLayerException;
import org.cleversafe.server.ClientSession;
import org.cleversafe.server.exceptions.IllegalSessionStateException;
import org.cleversafe.server.exceptions.ServerException;
import org.cleversafe.storage.ss.handlers.HandlerTestBase;
import org.cleversafe.vault.exceptions.VaultException;
import org.junit.Test;

public class BeginTransactionHandlerTest extends HandlerTestBase
{
   public static int transactionId = 0;

   // Creates a request to be used by the handler
   @Override
   protected Request createRequest()
   {
      return new BeginTransactionRequest(transactionId);
   }

   @Test(expected = IllegalSessionStateException.class)
   public final void testRequiresSliceStore() throws ProtocolLayerException,
         SliceStoreLayerException, ServerException, VaultException
   {
      checkRequiresSliceStore();
   }

   @Test
   public final void testService() throws Exception
   {
      ClientSession session = createClientSession();
      session = authenticateSession(session);
      session = addSliceStore(session);

      // Begin session on slice store
      getSliceStore(session).startSession();

      // Begin a transaction
      Response response = this.handler.service(createRequest(), session);

      assertEquals(false, response.getExceptionFlag());

      // Verify the transaction was created
      SliceStoreTransaction transaction = getSliceStore(session).getTransaction(transactionId);
      assertEquals(true, getSliceStore(session).isActiveTransaction(transaction));
      
      // End session on slice store
      getSliceStore(session).endSession();
   }

}
