package org.cleversafe.storage.ss.handlers.vault;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.util.UUID;

import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.layer.protocol.VaultBindRequest;
import org.cleversafe.layer.protocol.exceptions.ProtocolLayerException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreExistsException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreIOException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreLayerException;
import org.cleversafe.server.ClientSession;
import org.cleversafe.server.exceptions.IllegalSessionStateException;
import org.cleversafe.server.exceptions.ServerException;
import org.cleversafe.server.exceptions.UnauthorizedRequestException;
import org.cleversafe.storage.ss.handlers.HandlerTestBase;
import org.cleversafe.vault.exceptions.VaultException;
import org.junit.Test;

public class VaultBindHandlerTest extends HandlerTestBase
{
   public final UUID vaultIdentifier = UUID.randomUUID();
   
   // Creates a request to be used by the handler
   public Request createRequest()
   {      
      return new VaultBindRequest(this.vaultIdentifier);
   }
   
   @Test(expected = IllegalSessionStateException.class)
   public final void testRequiresAccountID() throws ProtocolLayerException, SliceStoreLayerException, ServerException, VaultException
   {
      ClientSession session = this.createClientSession();
      
      this.handler.service(createRequest(), session);
   }
   
   @Test(expected = IllegalSessionStateException.class)
   public final void testRequiresNoSliceStore() throws Exception
   {
      ClientSession session = this.createClientSession();
      session = this.authenticateSession(session);
      session = this.addSliceStore(session);
      
      this.handler.service(createRequest(), session);
   }

   @Test
   public final void testService() throws SliceStoreExistsException, SliceStoreIOException, Exception
   {
      // Create SliceStore in a separate session object
      this.addSliceStore(this.createClientSession(), this.vaultIdentifier);
      
      // Create session object to test bind vault command
      ClientSession session = this.createClientSession();
      session = this.authenticateSession(session);
      
      assertEquals(false, session.containsKey(ClientSession.SLICE_STORE));
      
      Response response = this.handler.service(createRequest(), session);
      
      // Check that no exception was thrown
      assertEquals(false, response.getExceptionFlag());
      
      // Check that correct VaultID was set in session
      assertEquals(this.vaultIdentifier, (UUID) session.get(ClientSession.VAULT_UUID));
      
      // Check that permission objects were added to the session
      assertEquals(true, session.containsKey(ClientSession.VAULT_PERMISSION));
      assertEquals(true, session.containsKey(ClientSession.LIST_PERMISSION));
      assertEquals(true, session.containsKey(ClientSession.READ_PERMISSION));
      assertEquals(true, session.containsKey(ClientSession.WRITE_PERMISSION));
   }



}
